/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.statesofmatter.view.instruments;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.colorado.phet.statesofmatter.StatesOfMatterStrings;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;

public class DialGaugeNode
extends PNode {
    private static final Color BACKGROUND_COLOR = new Color(245, 255, 250);
    private static final Color BORDER_COLOR = Color.LIGHT_GRAY;
    private static final Color NEEDLE_COLOR = Color.RED;
    private static final DecimalFormat NUMBER_FORMATTER = new DecimalFormat("##0.00");
    private final double m_diameter;
    private final PPath m_needle;
    private double m_needleAngle;
    private final PhetPPath m_connector;
    private final double m_needleLength;
    private final PText m_textualReadout;
    private final double m_minValue;
    private final double m_maxValue;
    private final String m_unitsLabel;
    private final RoundRectangle2D m_textualReadoutBoxShape;
    private final GeneralPath m_connectorPath;
    private boolean m_elbowEnabled;
    private double m_elbowHeight;
    private final PNode m_dialComponentsNode;

    public DialGaugeNode(double d, String string, double d2, double d3, String string2) {
        this.m_minValue = d2;
        this.m_maxValue = d3;
        this.m_unitsLabel = string2;
        this.m_elbowEnabled = false;
        this.m_diameter = d;
        double d4 = d * 0.015;
        this.m_dialComponentsNode = new PNode();
        this.m_dialComponentsNode.setOffset(0.0, 0.0);
        PPath pPath = new PPath(new Ellipse2D.Double(0.0, 0.0, d, d));
        pPath.setPaint(BACKGROUND_COLOR);
        pPath.setStrokePaint(BORDER_COLOR);
        pPath.setStroke(new BasicStroke((float)d4));
        this.m_dialComponentsNode.addChild(pPath);
        double d5 = 0.24802047265182578;
        BasicStroke basicStroke = new BasicStroke((float)(d * 0.008));
        for (double d6 = -3.6128315516282616; d6 <= 0.47123889803846897; d6 += d5) {
            PPath pPath2 = new PPath(new Line2D.Double(0.0, 0.0, d * 0.03, 0.0));
            pPath2.setStroke(basicStroke);
            pPath2.rotate(d6);
            pPath2.setOffset(d / 2.0 + d * 0.44 * Math.cos(d6), d / 2.0 + d * 0.44 * Math.sin(d6));
            this.m_dialComponentsNode.addChild(pPath2);
        }
        PText pText = new PText();
        pText.setText(string);
        pText.setFont(new PhetFont(12));
        pText.scale(this.m_dialComponentsNode.getFullBoundsReference().width * 0.6 / pText.getFullBoundsReference().width);
        pText.setOffset(d / 2.0 - pText.getFullBoundsReference().width / 2.0, d / 4.0);
        this.m_dialComponentsNode.addChild(pText);
        this.m_textualReadoutBoxShape = new RoundRectangle2D.Double(0.0, 0.0, 0.6 * d, 0.1 * d, 4.0, 4.0);
        PPath pPath3 = new PPath(this.m_textualReadoutBoxShape);
        float f = (float)(d * 0.01 * 3.0);
        pPath3.setStroke(new BasicStroke(f));
        pPath3.setStrokePaint(Color.YELLOW);
        pPath3.setPaint(Color.WHITE);
        pPath3.setOffset(d / 2.0 - pPath3.getWidth() / 2.0 + (double)(f / 2.0f), d * 0.7);
        this.m_dialComponentsNode.addChild(pPath3);
        PPath pPath4 = new PPath(this.m_textualReadoutBoxShape);
        float f2 = (float)(d * 0.01);
        pPath4.setStroke(new BasicStroke(f2));
        pPath4.setStrokePaint(Color.DARK_GRAY);
        pPath4.setOffset(d / 2.0 - pPath4.getWidth() / 2.0 + (double)(f2 / 2.0f), d * 0.7);
        this.m_dialComponentsNode.addChild(pPath4);
        this.m_textualReadout = new PText(" ");
        this.m_textualReadout.setFont(new PhetFont(12));
        this.m_textualReadout.scale(pPath4.getHeight() * 0.8 / this.m_textualReadout.getFullBoundsReference().height);
        pPath4.addChild(this.m_textualReadout);
        this.m_needleLength = d * 0.55;
        this.m_needle = new PPath(new Line2D.Double(0.0, 0.0, this.m_needleLength, 0.0));
        this.m_needle.setStroke(new BasicStroke((float)(d * 0.015)));
        this.m_needle.setStrokePaint(NEEDLE_COLOR);
        this.m_needle.setOffset(d / 2.0 - this.m_needleLength * 0.25, d / 2.0);
        this.m_needleAngle = -3.6128315516282616;
        this.m_needle.rotateAboutPoint(this.m_needleAngle, this.m_needleLength * 0.25, 0.0);
        this.m_dialComponentsNode.addChild(this.m_needle);
        double d7 = 0.02 * d;
        PPath pPath5 = new PPath(new Ellipse2D.Double(0.0, 0.0, d7, d7));
        pPath5.setPaint(Color.BLACK);
        pPath5.setOffset(d / 2.0 - d7 / 2.0, d / 2.0 - d7 / 2.0);
        this.m_dialComponentsNode.addChild(pPath5);
        this.m_connector = new PhetPPath();
        this.m_connector.setPaint(Color.BLUE);
        this.m_connectorPath = new GeneralPath();
        this.updateConnector();
        this.addChild(this.m_connector);
        this.addChild(this.m_dialComponentsNode);
        this.setValue(this.m_minValue);
    }

    public void setValue(double d) {
        boolean bl = false;
        if (d < this.m_minValue) {
            d = this.m_minValue;
        } else if (d > this.m_maxValue) {
            d = this.m_maxValue;
            bl = true;
        }
        double d2 = d / (this.m_maxValue - this.m_minValue);
        double d3 = -3.6128315516282616 + 4.084070449666731 * d2;
        this.m_needle.rotateAboutPoint(d3 - this.m_needleAngle, this.m_needleLength * 0.25, 0.0);
        this.m_needleAngle = d3;
        if (!bl) {
            this.m_textualReadout.setText(NUMBER_FORMATTER.format(d) + " " + this.m_unitsLabel);
            this.m_textualReadout.setTextPaint(Color.BLACK);
            this.m_textualReadout.setOffset(this.m_textualReadoutBoxShape.getWidth() / 2.0 - this.m_textualReadout.getFullBoundsReference().width / 2.0, this.m_textualReadoutBoxShape.getHeight() / 2.0 - this.m_textualReadout.getFullBoundsReference().height / 2.0);
        } else {
            this.m_textualReadout.setText(StatesOfMatterStrings.PRESSURE_GAUGE_OVERLOAD);
            this.m_textualReadout.setTextPaint(Color.RED);
            this.m_textualReadout.setOffset(this.m_textualReadoutBoxShape.getWidth() / 2.0 - this.m_textualReadout.getFullBoundsReference().width / 2.0, this.m_textualReadoutBoxShape.getHeight() / 2.0 - this.m_textualReadout.getFullBoundsReference().height / 2.0);
        }
    }

    public void setElbowEnabled(boolean bl) {
        this.m_elbowEnabled = bl;
        float f = (float)(0.15 * this.m_diameter);
        float f2 = (float)(0.3 * this.m_diameter);
        GradientPaint gradientPaint = this.m_elbowEnabled ? new GradientPaint(f2, f / 2.0f, Color.BLUE, f2 + f, f / 2.0f, Color.LIGHT_GRAY) : new GradientPaint((float)(this.m_diameter / 2.0), 0.0f, Color.LIGHT_GRAY, (float)(this.m_diameter / 2.0), (float)(0.15 * this.m_diameter), Color.BLUE);
        this.m_connector.setPaint(gradientPaint);
        this.updateConnector();
    }

    public void setElbowHeight(double d) {
        this.m_elbowHeight = d;
        this.updateConnector();
    }

    private void updateConnector() {
        float f = (float)(0.15 * this.m_diameter);
        float f2 = (float)(0.3 * this.m_diameter);
        if (!this.m_elbowEnabled) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, f2, f);
            this.m_connector.setPathTo(double_);
            this.m_connector.setOffset(this.m_dialComponentsNode.getFullBoundsReference().width * 0.9, this.m_diameter / 2.0 - (double)(f / 2.0f));
        } else {
            this.m_connectorPath.reset();
            this.m_connectorPath.moveTo(0.0f, 0.0f);
            if (Math.abs(this.m_elbowHeight) < (double)(f / 2.0f)) {
                this.m_connectorPath.lineTo(f2 + f, 0.0f);
                this.m_connectorPath.lineTo(f2 + f, f);
                this.m_connectorPath.lineTo(0.0f, f);
                this.m_connectorPath.closePath();
                this.m_connector.setPathTo(this.m_connectorPath);
            } else if (this.m_elbowHeight < 0.0) {
                this.m_connectorPath.lineTo(f2, 0.0f);
                this.m_connectorPath.lineTo(f2, (float)(this.m_elbowHeight + (double)(f / 2.0f)));
                this.m_connectorPath.lineTo(f2 + f, (float)(this.m_elbowHeight + (double)(f / 2.0f)));
                this.m_connectorPath.lineTo(f2 + f, f / 2.0f);
                this.m_connectorPath.quadTo(f2 + f, f, f2 + f / 2.0f, f);
                this.m_connectorPath.lineTo(0.0f, f);
                this.m_connectorPath.closePath();
                this.m_connector.setPathTo(this.m_connectorPath);
            } else {
                this.m_connectorPath.lineTo(f2 + f / 2.0f, 0.0f);
                this.m_connectorPath.quadTo(f2 + f, 0.0f, f2 + f, f / 2.0f);
                this.m_connectorPath.lineTo(f2 + f, (float)(this.m_elbowHeight + (double)(f / 2.0f)));
                this.m_connectorPath.lineTo(f2, (float)(this.m_elbowHeight + (double)(f / 2.0f)));
                this.m_connectorPath.lineTo(f2, f);
                this.m_connectorPath.lineTo(0.0f, f);
                this.m_connectorPath.closePath();
                this.m_connector.setPathTo(this.m_connectorPath);
            }
        }
    }
}

