/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ImmutableRectangle2D {
    public final double x;
    public final double y;
    public final double width;
    public final double height;

    public ImmutableRectangle2D(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
    }

    public ImmutableVector2D getCenter() {
        return new ImmutableVector2D(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.toRectangle2D().contains(rectangle2D);
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", width = " + this.width + ", height = " + this.height;
    }

    public Point2D getClosestPoint(Point2D point2D) {
        Point2D.Double double_ = new Point2D.Double(point2D.getX(), point2D.getY());
        if (double_.getX() < this.x) {
            double_.x = this.x;
        }
        if (double_.getX() > this.x + this.width) {
            double_.x = this.x + this.width;
        }
        if (double_.getY() < this.y) {
            double_.y = this.y;
        }
        if (double_.getY() > this.y + this.height) {
            double_.y = this.y + this.height;
        }
        return double_;
    }

    public Rectangle2D toRectangle2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    public double getMaxX() {
        return this.x + this.width;
    }

    public double getMaxY() {
        return this.y + this.height;
    }
}

