/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.conductivitytester;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.IConductivityTester;
import edu.colorado.phet.common.piccolophet.nodes.conductivitytester.LightRaysNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

public class ConductivityTesterNode
extends PhetPNode {
    private static final BufferedImage BATTERY = ConductivityTesterNode.getBufferedImage("battery.png");
    private static final BufferedImage LIGHT_BULB_BASE = ConductivityTesterNode.getBufferedImage("lightBulbBase.png");
    private static final BufferedImage LIGHT_BULB_GLASS = ConductivityTesterNode.getBufferedImage("lightBulbGlass.png");
    private static final BufferedImage LIGHT_BULB_GLASS_MASK = ConductivityTesterNode.getBufferedImage("lightBulbGlassMask.png");
    private static final Function.LinearFunction BRIGHTNESS_TO_ALPHA_FUNCTION_AGAINST_DARK_BACKGROUND = new Function.LinearFunction(0.0, 1.0, 0.3, 2.0);
    private static final Function.LinearFunction BRIGHTNESS_TO_ALPHA_FUNCTION_AGAINST_LIGHT_BACKGROUND = new Function.LinearFunction(0.0, 1.0, 0.85, 1.0);
    private static final Function.LinearFunction BRIGHTNESS_TO_INTENSITY_FUNCTION = new Function.LinearFunction(0.0, 1.0, 0.0, 1.0);
    private static final Color PROBE_STROKE_COLOR = Color.BLACK;
    private static final Stroke PROBE_STROKE = new BasicStroke(1.0f);
    private static final Font PROBE_LABEL_FONT = new PhetFont(1, 24);
    private static final Color DEFAULT_POSITIVE_PROBE_LABEL_COLOR = Color.WHITE;
    private static final Color DEFAULT_NEGATIVE_PROBE_LABEL_COLOR = Color.WHITE;
    private static final Stroke WIRE_STROKE = new BasicStroke(3.0f);
    private Function.LinearFunction bulbBrightnessFunction = BRIGHTNESS_TO_ALPHA_FUNCTION_AGAINST_LIGHT_BACKGROUND;
    private final ModelViewTransform transform;
    private final IConductivityTester tester;
    private final LightBulbNode lightBulbNode;
    private final LightRaysNode lightRaysNode;
    private final BatteryNode batteryNode;
    private final ProbeNode positiveProbeNode;
    private final ProbeNode negativeProbeNode;
    private final CubicWireNode positiveWireNode;
    private final CubicWireNode negativeWireNode;
    private final ValueNode valueNode;

    private static BufferedImage getBufferedImage(String string) {
        return new PhetResources("piccolo-phet").getImage(string);
    }

    public ConductivityTesterNode(final IConductivityTester iConductivityTester, ModelViewTransform modelViewTransform, Color color, Color color2, Color color3, Color color4, Color color5, Color color6, Color color7, boolean bl) {
        this.transform = modelViewTransform;
        this.tester = iConductivityTester;
        this.lightBulbNode = new LightBulbNode();
        this.lightBulbNode.setScale(0.6);
        double d = this.lightBulbNode.getFullBoundsReference().getWidth() / 2.0;
        this.lightRaysNode = new LightRaysNode(d);
        this.batteryNode = new BatteryNode();
        StraightWireNode straightWireNode = new StraightWireNode(color3);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        Point2D.Double double_2 = new Point2D.Double(0.0, 50.0);
        straightWireNode.setEndPoints(double_, double_2);
        this.positiveProbeNode = new ProbeNode(modelViewTransform.modelToViewSize(iConductivityTester.getProbeSizeReference()), color4, "+", color7);
        this.positiveProbeNode.addInputEventListener(new CursorHandler(8));
        this.positiveProbeNode.addInputEventListener(new ProbeDragHandler(modelViewTransform, this.positiveProbeNode, new Function0<Point2D>(){

            @Override
            public Point2D apply() {
                return iConductivityTester.getPositiveProbeLocationReference();
            }
        }, new VoidFunction1<Point2D>(){

            @Override
            public void apply(Point2D point2D) {
                iConductivityTester.setPositiveProbeLocation(point2D.getX(), point2D.getY());
            }
        }));
        this.negativeProbeNode = new ProbeNode(modelViewTransform.modelToViewSize(iConductivityTester.getProbeSizeReference()), color5, "-", color6);
        this.negativeProbeNode.addInputEventListener(new CursorHandler(8));
        this.negativeProbeNode.addInputEventListener(new ProbeDragHandler(modelViewTransform, this.negativeProbeNode, new Function0<Point2D>(){

            @Override
            public Point2D apply() {
                return iConductivityTester.getNegativeProbeLocationReference();
            }
        }, new VoidFunction1<Point2D>(){

            @Override
            public void apply(Point2D point2D) {
                iConductivityTester.setNegativeProbeLocation(point2D.getX(), point2D.getY());
            }
        }));
        this.positiveWireNode = new CubicWireNode(color, 25.0, -100.0);
        this.negativeWireNode = new CubicWireNode(color2, -25.0, -100.0);
        this.valueNode = new ValueNode();
        this.addChild(this.lightRaysNode);
        this.addChild(this.positiveWireNode);
        this.addChild(this.negativeWireNode);
        this.addChild(this.positiveProbeNode);
        this.addChild(this.negativeProbeNode);
        this.addChild(straightWireNode);
        this.addChild(this.lightBulbNode);
        this.addChild(this.batteryNode);
        if (bl) {
            this.addChild(this.valueNode);
        }
        double d2 = 0.0;
        double d3 = 0.0;
        this.lightBulbNode.setOffset(d2, d3);
        d2 = this.lightBulbNode.getFullBoundsReference().getCenterX();
        d3 = this.lightBulbNode.getFullBoundsReference().getMinY() + d;
        this.lightRaysNode.setOffset(d2, d3);
        d2 = this.lightBulbNode.getFullBoundsReference().getCenterX() + 50.0;
        d3 = this.lightBulbNode.getFullBounds().getMaxY();
        this.batteryNode.setOffset(d2, d3);
        straightWireNode.setOffset(this.lightBulbNode.getFullBoundsReference().getCenterX(), this.lightBulbNode.getFullBoundsReference().getMaxY());
        d2 = this.lightBulbNode.getFullBoundsReference().getCenterX();
        d3 = this.batteryNode.getFullBoundsReference().getMaxY() + 3.0;
        this.valueNode.setOffset(d2, d3);
        this.setOffset(modelViewTransform.modelToView(iConductivityTester.getLocationReference()));
        this.setVisible(iConductivityTester.isVisible());
        iConductivityTester.addConductivityTesterChangeListener(new IConductivityTester.ConductivityTesterChangeListener(){

            public void positiveProbeLocationChanged() {
                ConductivityTesterNode.this.updatePositiveProbeLocation();
            }

            public void negativeProbeLocationChanged() {
                ConductivityTesterNode.this.updateNegativeProbeLocation();
            }

            public void locationChanged() {
                ConductivityTesterNode.this.updateLocation();
            }

            public void brightnessChanged() {
                ConductivityTesterNode.this.updateBrightness();
            }
        });
        this.updateBrightness();
        this.updatePositiveProbeLocation();
        this.updateNegativeProbeLocation();
    }

    public PNode getLightBulbNode() {
        return this.lightBulbNode;
    }

    protected PNode getBatteryNode() {
        return this.batteryNode;
    }

    private void updateLocation() {
        this.setOffset(this.tester.getLocationReference());
        this.updatePositiveProbeLocation();
        this.updateNegativeProbeLocation();
    }

    private void updatePositiveProbeLocation() {
        Point2D.Double double_ = new Point2D.Double(this.tester.getPositiveProbeLocationReference().getX(), this.tester.getPositiveProbeLocationReference().getY());
        Point2D point2D = this.transform.modelToView(double_);
        this.positiveProbeNode.setOffset(point2D.getX() - this.getOffset().getX(), point2D.getY() - this.getOffset().getY());
        double d = this.batteryNode.getFullBoundsReference().getMaxX();
        double d2 = this.batteryNode.getFullBoundsReference().getCenterY();
        Point2D.Double double_2 = new Point2D.Double(d, d2);
        d = this.positiveProbeNode.getFullBoundsReference().getCenterX();
        d2 = this.positiveProbeNode.getFullBoundsReference().getMinY();
        Point2D.Double double_3 = new Point2D.Double(d, d2);
        this.positiveWireNode.setEndPoints(double_2, double_3);
    }

    private void updateNegativeProbeLocation() {
        Point2D.Double double_ = new Point2D.Double(this.tester.getNegativeProbeLocationReference().getX(), this.tester.getNegativeProbeLocationReference().getY());
        Point2D point2D = this.transform.modelToView(double_);
        this.negativeProbeNode.setOffset(point2D.getX() - this.getOffset().getX(), point2D.getY() - this.getOffset().getY());
        double d = this.lightBulbNode.getFullBoundsReference().getCenterX();
        double d2 = this.lightBulbNode.getFullBoundsReference().getMaxY() - this.lightBulbNode.getFullBoundsReference().getHeight() * 0.12;
        Point2D.Double double_2 = new Point2D.Double(d, d2);
        d = this.negativeProbeNode.getFullBoundsReference().getCenterX();
        d2 = this.negativeProbeNode.getFullBoundsReference().getMinY();
        Point2D.Double double_3 = new Point2D.Double(d, d2);
        this.negativeWireNode.setEndPoints(double_2, double_3);
    }

    private void updateBrightness() {
        this.lightBulbNode.setGlassTransparency(MathUtil.clamp(0.0, this.bulbBrightnessFunction.evaluate(this.tester.getBrightness()), 1.0));
        this.lightRaysNode.setIntensity(BRIGHTNESS_TO_INTENSITY_FUNCTION.evaluate(this.tester.getBrightness()));
        this.valueNode.setValue(this.tester.getBrightness());
    }

    public void setAgainstDarkBackground() {
        this.bulbBrightnessFunction = BRIGHTNESS_TO_ALPHA_FUNCTION_AGAINST_DARK_BACKGROUND;
        this.lightBulbNode.setMaskVisible(false);
        this.lightRaysNode.setRayColor(LightRaysNode.DEFAULT_RAY_COLOR_AGAINST_DARK_BACKGROUND);
        this.updateBrightness();
    }

    public void setAgainstWhiteBackground() {
        this.bulbBrightnessFunction = BRIGHTNESS_TO_ALPHA_FUNCTION_AGAINST_LIGHT_BACKGROUND;
        this.lightBulbNode.setMaskVisible(true);
        this.lightRaysNode.setRayColor(LightRaysNode.DEFAULT_RAY_COLOR_AGAINST_LIGHT_BACKGROUND);
        this.updateBrightness();
    }

    private static class BatteryNode
    extends PComposite {
        public BatteryNode() {
            PImage pImage = new PImage(BATTERY);
            this.addChild(pImage);
            double d = 0.0;
            double d2 = -pImage.getFullBoundsReference().getHeight() / 2.0;
            pImage.setOffset(d, d2);
        }
    }

    private static class CubicWireNode
    extends PPath {
        private final double controlPointDx;
        private final double controlPointDy;

        public CubicWireNode(Color color, double d, double d2) {
            this.controlPointDx = d;
            this.controlPointDy = d2;
            this.setStroke(WIRE_STROKE);
            this.setStrokePaint(color);
        }

        public void setEndPoints(Point2D point2D, Point2D point2D2) {
            Point2D.Double double_ = new Point2D.Double(point2D.getX() + this.controlPointDx, point2D.getY());
            Point2D.Double double_2 = new Point2D.Double(point2D2.getX(), point2D2.getY() + this.controlPointDy);
            this.setPathTo(new CubicCurve2D.Double(point2D.getX(), point2D.getY(), ((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY(), point2D2.getX(), point2D2.getY()));
        }
    }

    private static class LightBulbNode
    extends PComposite {
        private final PImage glassNode;
        private PNode maskNode;

        public LightBulbNode() {
            PImage pImage = new PImage(LIGHT_BULB_BASE);
            this.glassNode = new PImage(LIGHT_BULB_GLASS);
            this.maskNode = new PImage(LIGHT_BULB_GLASS_MASK);
            this.addChild(this.maskNode);
            this.addChild(this.glassNode);
            this.addChild(pImage);
            double d = -pImage.getFullBoundsReference().getWidth() / 2.0;
            double d2 = -pImage.getFullBoundsReference().getHeight();
            pImage.setOffset(d, d2);
            d = pImage.getFullBoundsReference().getCenterX() - this.glassNode.getFullBoundsReference().getWidth() / 2.0;
            d2 = pImage.getFullBoundsReference().getMinY() - this.glassNode.getFullBoundsReference().getHeight();
            this.glassNode.setOffset(d, d2);
            this.maskNode.setOffset(this.glassNode.getOffset());
        }

        public void setGlassTransparency(double d) {
            this.glassNode.setTransparency((float)d);
        }

        public void setMaskVisible(boolean bl) {
            this.maskNode.setVisible(bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProbeDragHandler
    extends PBasicInputEventHandler {
        private final ProbeNode probeNode;
        private final ModelViewTransform transform;
        private final Function0<Point2D> getModelLocation;
        private final VoidFunction1<Point2D> setModelLocation;
        private Point2D.Double relativeGrabPoint;

        ProbeDragHandler(ModelViewTransform modelViewTransform, ProbeNode probeNode, Function0<Point2D> function0, VoidFunction1<Point2D> voidFunction1) {
            this.transform = modelViewTransform;
            this.probeNode = probeNode;
            this.getModelLocation = function0;
            this.setModelLocation = voidFunction1;
        }

        @Override
        public void mousePressed(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.probeNode.getParent());
            Point2D point2D2 = this.transform.modelToView(this.getModelLocation.apply());
            this.relativeGrabPoint = new Point2D.Double(point2D.getX() - point2D2.getX(), point2D.getY() - point2D2.getY());
        }

        @Override
        public void mouseReleased(PInputEvent pInputEvent) {
            this.relativeGrabPoint = null;
        }

        @Override
        public void mouseDragged(PInputEvent pInputEvent) {
            Point2D point2D = pInputEvent.getPositionRelativeTo(this.probeNode.getParent());
            Point2D point2D2 = this.transform.viewToModel(point2D.getX() - this.relativeGrabPoint.getX(), point2D.getY() - this.relativeGrabPoint.getY());
            this.setModelLocation.apply(new Point2D.Double(this.getModelLocation.apply().getX(), point2D2.getY()));
        }
    }

    private static class ProbeNode
    extends PhetPNode {
        public ProbeNode(Dimension2D dimension2D, Color color, String string, Color color2) {
            PPath pPath = new PPath(new Rectangle2D.Double(-dimension2D.getWidth() / 2.0, -dimension2D.getHeight(), dimension2D.getWidth(), Math.abs(dimension2D.getHeight())));
            pPath.setStroke(PROBE_STROKE);
            pPath.setStrokePaint(PROBE_STROKE_COLOR);
            pPath.setPaint(color);
            this.addChild(pPath);
            PText pText = new PText(string);
            pText.setTextPaint(color2);
            pText.setFont(PROBE_LABEL_FONT);
            this.addChild(pText);
            double d = pPath.getFullBoundsReference().getCenterX() - pText.getFullBoundsReference().getWidth() / 2.0;
            double d2 = pPath.getFullBoundsReference().getMaxY() - pText.getFullBoundsReference().getHeight() - 3.0;
            pText.setOffset(d, d2);
        }
    }

    private static class StraightWireNode
    extends PPath {
        public StraightWireNode(Color color) {
            this.setStroke(WIRE_STROKE);
            this.setStrokePaint(color);
        }

        public void setEndPoints(Point2D point2D, Point2D point2D2) {
            this.setPathTo(new Line2D.Double(0.0, 0.0, 50.0, 0.0));
        }
    }

    private static class ValueNode
    extends PText {
        private static final DecimalFormat FORMAT = new DecimalFormat("0.000");

        public ValueNode() {
            this(0.0);
        }

        public ValueNode(double d) {
            this.setTextPaint(Color.RED);
            this.setFont(new PhetFont(16));
            this.setValue(d);
        }

        public void setValue(double d) {
            this.setText("brightness=" + FORMAT.format(d));
        }
    }
}

