/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.conductivitytester;

import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;

class LightRaysNode
extends PComposite {
    private static final double RAYS_START_ANGLE = Math.toRadians(135.0);
    private static final double RAYS_ARC_ANGLE = Math.toRadians(270.0);
    public static final Color DEFAULT_RAY_COLOR_AGAINST_DARK_BACKGROUND = Color.YELLOW;
    public static final Color DEFAULT_RAY_COLOR_AGAINST_LIGHT_BACKGROUND = new Color(232, 167, 54);
    private static final BasicStroke RAY_STROKE_BIG = new BasicStroke(3.0f, 1, 1);
    private static final BasicStroke RAY_STROKE_MEDIUM = new BasicStroke(2.0f, 1, 1);
    private static final BasicStroke RAY_STROKE_SMALL = new BasicStroke(1.0f, 1, 1);
    private final double bulbRadius;
    private double intensity;
    private Color rayColor = DEFAULT_RAY_COLOR_AGAINST_DARK_BACKGROUND;
    private final PPath[] cachePPaths;
    private final Line2D[] cacheLines;

    public LightRaysNode(double d) {
        this.bulbRadius = d;
        this.intensity = 0.0;
        this.cachePPaths = new PPath[60];
        this.cacheLines = new Line2D[60];
        for (int i = 0; i < 60; ++i) {
            this.cachePPaths[i] = new PPath();
            this.cacheLines[i] = new Line2D.Double();
        }
        this.update();
        this.setPickable(false);
        this.setChildrenPickable(false);
    }

    public void setIntensity(double d) {
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new IllegalArgumentException("intensity range is 0-1: " + d);
        }
        if (d != this.intensity) {
            this.intensity = d;
            this.update();
        }
    }

    public void setRayColor(Color color) {
        this.rayColor = color;
        this.update();
    }

    private void update() {
        this.removeAllChildren();
        if (this.intensity == 0.0) {
            return;
        }
        int n = 8 + (int)(this.intensity * 52.0);
        double d = 0.0 + this.intensity * 350.0;
        BasicStroke basicStroke = RAY_STROKE_SMALL;
        if (d > 210.0) {
            basicStroke = RAY_STROKE_BIG;
        } else if (d > 105.0) {
            basicStroke = RAY_STROKE_MEDIUM;
        }
        double d2 = RAYS_START_ANGLE;
        double d3 = RAYS_ARC_ANGLE / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            double d4 = Math.cos(d2) * this.bulbRadius;
            double d5 = Math.sin(d2) * this.bulbRadius;
            double d6 = Math.cos(d2) * (this.bulbRadius + d);
            double d7 = Math.sin(d2) * (this.bulbRadius + d);
            Line2D line2D = this.cacheLines[i];
            line2D.setLine(d4, d5, d6, d7);
            PPath pPath = this.cachePPaths[i];
            pPath.setPathTo(line2D);
            pPath.setStroke(basicStroke);
            pPath.setStrokePaint(this.rayColor);
            this.addChild(pPath);
            d2 += d3;
        }
    }
}

