/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.toolbox;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.DragEvent;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;

public abstract class CanvasBoundedDragHandler
extends PBasicInputEventHandler {
    private Point2D lastLocation;
    private PNode node;

    public CanvasBoundedDragHandler(PNode pNode) {
        this.node = pNode;
    }

    public CanvasBoundedDragHandler(PNode pNode, PInputEvent pInputEvent) {
        this(pNode);
        this.mousePressed(pInputEvent);
    }

    public void mousePressed(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.node.getParent().getParent());
        point2D = this.node.getParent().getParent().localToGlobal(point2D);
        this.lastLocation = new Point2D.Double(point2D.getX(), point2D.getY());
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        if (this.lastLocation == null) {
            this.mousePressed(pInputEvent);
        }
        Point2D point2D = pInputEvent.getPositionRelativeTo(this.node.getParent().getParent());
        point2D = this.node.getParent().getParent().localToGlobal(point2D);
        ImmutableRectangle2D immutableRectangle2D = new ImmutableRectangle2D(10.0, 10.0, pInputEvent.getSourceSwingEvent().getComponent().getWidth() - 20, pInputEvent.getSourceSwingEvent().getComponent().getHeight() - 20);
        Point2D point2D2 = immutableRectangle2D.getClosestPoint(point2D);
        Dimension2D dimension2D = new PDimension(point2D2.getX() - this.lastLocation.getX(), point2D2.getY() - this.lastLocation.getY());
        dimension2D = this.node.globalToLocal(dimension2D);
        dimension2D = this.node.localToParent(dimension2D);
        this.dragNode(new DragEvent(pInputEvent, new PDimension(dimension2D.getWidth(), dimension2D.getHeight())));
        this.lastLocation = point2D2;
    }

    protected abstract void dragNode(DragEvent var1);

    public void mouseReleased(PInputEvent pInputEvent) {
        this.lastLocation = null;
    }
}

