/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.nodes.toolbox;

import edu.colorado.phet.common.phetcommon.model.ResetModel;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.colorado.phet.common.piccolophet.nodes.ToolNode;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.BoundedToolDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.CanvasBoundedDragHandler;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.NodeFactory;
import edu.colorado.phet.common.piccolophet.nodes.toolbox.ToolboxCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolIconNode<T extends PhetPCanvas>
extends PNode {
    private final Property<Boolean> showToolInPlayArea;
    private final ModelViewTransform transform;
    private final T canvas;
    private final NodeFactory nodeMaker;
    private final ResetModel resetModel;
    private final Function0<Rectangle2D> globalToolboxBounds;
    private final boolean dragMultiple;

    public ToolIconNode(Image image, Property<Boolean> property, ModelViewTransform modelViewTransform, T t, NodeFactory nodeFactory, ResetModel resetModel, Function0<Rectangle2D> function0) {
        this(image, property, modelViewTransform, t, nodeFactory, resetModel, function0, false);
    }

    public ToolIconNode(Image image, final Property<Boolean> property, ModelViewTransform modelViewTransform, T t, NodeFactory nodeFactory, ResetModel resetModel, Function0<Rectangle2D> function0, boolean bl) {
        this.showToolInPlayArea = property;
        this.transform = modelViewTransform;
        this.canvas = t;
        this.nodeMaker = nodeFactory;
        this.resetModel = resetModel;
        this.globalToolboxBounds = function0;
        this.dragMultiple = bl;
        this.addChild(new PImage(image){
            {
                super(image);
                property.addObserver(new SimpleObserver(){

                    public void update() {
                        this.setVisible((Boolean)property.get() == false);
                    }
                });
                this.addInputEventListener(new ToolDragListener(this));
                this.addInputEventListener(new CursorHandler());
            }
        });
    }

    protected void addChild(T t, ToolNode toolNode) {
        ((ToolboxCanvas)t).addChild(toolNode);
    }

    protected void removeChild(T t, ToolNode toolNode) {
        ((ToolboxCanvas)t).removeChild(toolNode);
    }

    class ToolDragListener
    extends PBasicInputEventHandler {
        private final PImage thumbnailIcon;
        private ToolNode node = null;
        boolean intersect = false;
        private CanvasBoundedDragHandler dragHandler;
        private PropertyChangeListener boundChangeListener;

        ToolDragListener(PImage pImage) {
            this.thumbnailIcon = pImage;
            ToolIconNode.this.resetModel.addResetListener(new VoidFunction0(){

                public void apply() {
                    ToolDragListener.this.reset();
                }
            });
        }

        public void mousePressed(PInputEvent pInputEvent) {
            if (!ToolIconNode.this.dragMultiple) {
                ToolIconNode.this.showToolInPlayArea.set(true);
                this.thumbnailIcon.setVisible(false);
            }
            if (this.node == null || ToolIconNode.this.dragMultiple) {
                ToolNode toolNode;
                this.node = toolNode = ToolIconNode.this.nodeMaker.createNode(ToolIconNode.this.transform, ToolIconNode.this.showToolInPlayArea, ToolIconNode.this.transform.viewToModel(pInputEvent.getPositionRelativeTo(((ToolboxCanvas)((Object)ToolIconNode.this.canvas)).getRootNode())));
                this.boundChangeListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        boolean bl = false;
                        for (PNode pNode : toolNode.getDroppableComponents()) {
                            PBounds pBounds = pNode.getGlobalFullBounds();
                            if (!((Rectangle2D)ToolIconNode.this.globalToolboxBounds.apply()).contains(pBounds.getCenterX(), pBounds.getCenterY())) continue;
                            bl = true;
                        }
                        ToolDragListener.this.intersect = bl;
                    }
                };
                toolNode.addPropertyChangeListener("fullBounds", this.boundChangeListener);
                toolNode.addInputEventListener(new PBasicInputEventHandler(){

                    public void mouseReleased(PInputEvent pInputEvent) {
                        ToolDragListener.this.testDropIn(toolNode);
                    }
                });
                ToolIconNode.this.addChild(ToolIconNode.this.canvas, toolNode);
                this.dragHandler = new BoundedToolDragHandler(toolNode, pInputEvent);
                ToolIconNode.this.resetModel.addResetListener(new VoidFunction0(){

                    public void apply() {
                        ToolIconNode.this.removeChild(ToolIconNode.this.canvas, toolNode);
                    }
                });
            }
        }

        public void mouseDragged(PInputEvent pInputEvent) {
            this.dragHandler.mouseDragged(pInputEvent);
        }

        public void mouseReleased(PInputEvent pInputEvent) {
            this.testDropIn(this.node);
        }

        public void testDropIn(ToolNode toolNode) {
            if (this.intersect) {
                ToolIconNode.this.showToolInPlayArea.set(false);
                this.thumbnailIcon.setVisible(true);
                if (toolNode != null && this.boundChangeListener != null) {
                    toolNode.removePropertyChangeListener(this.boundChangeListener);
                }
                if (toolNode != null) {
                    ToolIconNode.this.removeChild(ToolIconNode.this.canvas, toolNode);
                }
                this.reset();
            }
        }

        private void reset() {
            this.node = null;
        }
    }
}

