/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compound<T extends Particle>
extends Particle
implements Iterable<T> {
    protected final ItemList<Constituent<T>> constituents = new ItemList();
    private Option<Double> underwaterTime = new Option.None<Double>();
    private double angle;

    public Compound(ImmutableVector2D immutableVector2D, double d) {
        super(immutableVector2D);
        this.angle = d;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setPosition(ImmutableVector2D immutableVector2D) {
        super.setPosition(immutableVector2D);
        this.updateConstituentLocations();
    }

    public void updateConstituentLocations() {
        for (Constituent constituent : this.constituents) {
            this.updateConstituentLocation(constituent);
        }
    }

    private void updateConstituentLocation(Constituent constituent) {
        ((Particle)constituent.particle).setPosition(this.getPosition().plus(constituent.relativePosition.getRotatedInstance(this.angle)));
    }

    @Override
    public Shape getShape() {
        Rectangle2D rectangle2D = ((Particle)((Constituent)this.constituents.get((int)0)).particle).getShape().getBounds2D();
        Rectangle2D rectangle2D2 = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        for (Constituent constituent : this.constituents) {
            rectangle2D2 = ((Rectangle2D)rectangle2D2).createUnion(((Particle)constituent.particle).getShape().getBounds2D());
        }
        return rectangle2D2;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayList<T>(){
            {
                for (Constituent constituent : Compound.this.constituents) {
                    this.add(constituent.particle);
                }
            }
        }.iterator();
    }

    public boolean isUnderwaterTimeRecorded() {
        return this.underwaterTime.isSome();
    }

    public void setUnderwater(double d) {
        this.underwaterTime = new Option.Some<Double>(d);
    }

    public double getUnderWaterTime() {
        return this.underwaterTime.get();
    }

    public int numberConstituents() {
        return this.constituents.size();
    }

    public Constituent<T> getConstituent(int n) {
        return (Constituent)this.constituents.get(n);
    }

    public void removeConstituent(Constituent<T> constituent) {
        this.constituents.remove(constituent);
    }

    public void addConstituent(Constituent<T> constituent) {
        this.constituents.add(constituent);
        this.updateConstituentLocation(constituent);
    }

    public Iterable<SphericalParticle> getAllSphericalParticles() {
        ArrayList<SphericalParticle> arrayList = new ArrayList<SphericalParticle>();
        for (Constituent constituent : this.constituents) {
            if (constituent.particle instanceof SphericalParticle) {
                arrayList.add((SphericalParticle)constituent.particle);
                continue;
            }
            if (!(constituent.particle instanceof Compound)) continue;
            Compound compound = (Compound)constituent.particle;
            Iterable<SphericalParticle> iterable = compound.getAllSphericalParticles();
            for (SphericalParticle sphericalParticle : iterable) {
                arrayList.add(sphericalParticle);
            }
        }
        return arrayList;
    }

    public boolean containsParticle(T t) {
        return this.constituents.contains(new Function1<Constituent<T>, Boolean>((Particle)t){
            final /* synthetic */ Particle val$particle;
            {
                this.val$particle = particle;
            }

            @Override
            public Boolean apply(Constituent<T> constituent) {
                return constituent.particle == this.val$particle;
            }
        });
    }

    public void setPositionAndAngle(ImmutableVector2D immutableVector2D, float f) {
        super.setPosition(immutableVector2D);
        this.angle = f;
        this.updateConstituentLocations();
    }

    public ArrayList<T> getConstituentParticleList() {
        return new ArrayList<T>(){
            {
                for (Particle particle : Compound.this) {
                    this.add(particle);
                }
            }
        };
    }

    public ItemList<Constituent<T>> getConstituents() {
        return new ItemList<Constituent<T>>(this.constituents);
    }
}

