/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.OpenSite;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Crystal<T extends Particle>
extends Compound<T> {
    public final Formula formula;
    public final double spacing;
    protected final ImmutableVector2D northUnitVector;
    protected final ImmutableVector2D southUnitVector;
    protected final ImmutableVector2D eastUnitVector;
    protected final ImmutableVector2D westUnitVector;
    public final Random random = new Random();
    private static final Logger LOGGER = LoggingUtils.getLogger(Crystal.class.getCanonicalName());

    public Crystal(Formula formula, ImmutableVector2D immutableVector2D, double d, double d2) {
        super(immutableVector2D, d2);
        this.formula = formula;
        this.spacing = d;
        this.updateConstituentLocations();
        this.northUnitVector = new ImmutableVector2D(0.0, 1.0).times(d).getRotatedInstance(d2);
        this.southUnitVector = new ImmutableVector2D(0.0, -1.0).times(d).getRotatedInstance(d2);
        this.eastUnitVector = new ImmutableVector2D(1.0, 0.0).times(d).getRotatedInstance(d2);
        this.westUnitVector = new ImmutableVector2D(-1.0, 0.0).times(d).getRotatedInstance(d2);
    }

    public abstract T createPartner(T var1);

    public boolean grow(int n) {
        int n2 = 10000;
        for (int i = 0; i < n2; ++i) {
            boolean bl = this.growRandomly(n);
            if (bl) {
                return true;
            }
            System.out.println("crystal growth failed: tryIndex = " + i);
            while (this.numberConstituents() > 0) {
                this.removeConstituent(this.getConstituent(0));
            }
        }
        return false;
    }

    private boolean growRandomly(int n) {
        for (int i = 0; i < n; ++i) {
            boolean bl = this.growByOneFormulaUnit();
            if (bl) continue;
            return false;
        }
        return true;
    }

    public boolean growByOneFormulaUnit() {
        for (final Class<? extends Particle> clazz : this.formula.getFormulaUnit()) {
            if (this.constituents.size() == 0) {
                this.addConstituent(new Constituent<T>(this.createConstituentParticle(clazz), ImmutableVector2D.ZERO));
                continue;
            }
            ItemList<OpenSite<T>> itemList = this.getOpenSites().filter(new Function1<OpenSite<T>, Boolean>(){

                @Override
                public Boolean apply(OpenSite<T> openSite) {
                    return openSite.matches(clazz);
                }
            });
            if (itemList.size() > 0) {
                this.addConstituent(((OpenSite)itemList.get(this.random.nextInt(itemList.size()))).toConstituent());
                continue;
            }
            return false;
        }
        return true;
    }

    public ItemList<OpenSite<T>> getOpenSites() {
        ItemList itemList = new ItemList();
        for (final Constituent constituent : new ArrayList(this.constituents)) {
            for (ImmutableVector2D immutableVector2D : this.getPossibleDirections(constituent)) {
                ImmutableVector2D immutableVector2D2 = constituent.relativePosition.plus(immutableVector2D);
                if (this.isOccupied(immutableVector2D2)) continue;
                Object t = this.createPartner(constituent.particle);
                ImmutableVector2D immutableVector2D3 = immutableVector2D2.plus(this.getPosition());
                ((Particle)t).setPosition(immutableVector2D3);
                itemList.add(new OpenSite(immutableVector2D2, ((Particle)t).getShape(), new Function0<T>(){

                    @Override
                    public T apply() {
                        return Crystal.this.createPartner(constituent.particle);
                    }
                }, immutableVector2D3));
            }
        }
        return itemList;
    }

    public ImmutableVector2D[] getPossibleDirections(Constituent<T> constituent) {
        return new ImmutableVector2D[]{this.northUnitVector, this.southUnitVector, this.eastUnitVector, this.westUnitVector};
    }

    public boolean isOccupied(ImmutableVector2D immutableVector2D) {
        return this.getConstituentAtLocation(immutableVector2D).isSome();
    }

    public Option<Constituent<T>> getConstituentAtLocation(final ImmutableVector2D immutableVector2D) {
        ItemList itemList = this.constituents.filter(new Function1<Constituent<T>, Boolean>(){

            @Override
            public Boolean apply(Constituent<T> constituent) {
                return constituent.relativePosition.minus(immutableVector2D).getMagnitude() < Crystal.this.spacing / 100.0;
            }
        });
        if (itemList.size() > 1) {
            new RuntimeException("Too many particles at the same location, getting one of them randomly").printStackTrace();
            int n = this.random.nextInt(itemList.size());
            return new Option.Some<Constituent<T>>(itemList.get(n));
        }
        if (itemList.size() == 0) {
            return new Option.None<Constituent<T>>();
        }
        return new Option.Some<Constituent<T>>(itemList.get(0));
    }

    @Override
    public void addConstituent(Constituent<T> constituent) {
        super.addConstituent(constituent);
        Option<Constituent<T>> option = this.getConstituentAtLocation(constituent.relativePosition);
        if (!option.isSome() || option.get() != constituent) {
            new RuntimeException("Wrong constituent during add process").printStackTrace();
        }
    }

    protected abstract T createConstituentParticle(Class<? extends Particle> var1);

    public Option<ArrayList<Constituent<T>>> getConstituentsToDissolve(Rectangle2D rectangle2D) {
        ArrayList<Constituent<T>> arrayList = new ArrayList<Constituent<T>>();
        for (Class<? extends Particle> clazz : this.formula.getFormulaUnit()) {
            Constituent<T> constituent = this.getConstituentToDissolve(clazz, rectangle2D, arrayList);
            if (constituent == null) {
                return new Option.None<ArrayList<Constituent<T>>>();
            }
            arrayList.add(constituent);
        }
        return new Option.Some<ArrayList<Constituent<T>>>(arrayList);
    }

    public Constituent<T> getConstituentToDissolve(final Class<? extends Particle> clazz, final Rectangle2D rectangle2D, final ArrayList<Constituent<T>> arrayList) {
        ItemList itemList = this.constituents.filter(new Function1<Constituent<T>, Boolean>(){

            @Override
            public Boolean apply(Constituent<T> constituent) {
                return rectangle2D.contains(((Particle)constituent.particle).getShape().getBounds2D());
            }
        }).filter(new Function1<Constituent<T>, Boolean>(){

            @Override
            public Boolean apply(Constituent<T> constituent) {
                return clazz.isInstance(constituent.particle);
            }
        }).filter(new Function1<Constituent<T>, Boolean>(){

            @Override
            public Boolean apply(Constituent<T> constituent) {
                return !arrayList.contains(constituent);
            }
        });
        if (itemList.size() > 0) {
            final int n = this.getNumBonds((Constituent)Collections.min(itemList, new Comparator<Constituent<T>>(){

                @Override
                public int compare(Constituent<T> constituent, Constituent<T> constituent2) {
                    return Double.compare(Crystal.this.getNumBonds(constituent), Crystal.this.getNumBonds(constituent2));
                }
            }));
            itemList = itemList.filter(new Function1<Constituent<T>, Boolean>(){

                @Override
                public Boolean apply(Constituent<T> constituent) {
                    return Crystal.this.getNumBonds(constituent) == n;
                }
            });
            Collections.sort(itemList, new Comparator<Constituent>(){

                @Override
                public int compare(Constituent constituent, Constituent constituent2) {
                    return Double.compare(((Particle)constituent.particle).getPosition().getY(), ((Particle)constituent2.particle).getPosition().getY());
                }
            });
            LOGGER.fine("Crystal num components = " + itemList.size());
            for (int i = 0; i < itemList.size(); ++i) {
                LOGGER.fine("" + i + ": " + this.getNumBonds((Constituent)itemList.get(i)));
            }
            LOGGER.fine("END crystal");
            if (itemList.size() > 0) {
                return (Constituent)itemList.get(itemList.size() - 1);
            }
        }
        return null;
    }

    public boolean isConnected() {
        if (this.constituents.isEmpty()) {
            return true;
        }
        ArrayList arrayList = new ArrayList<Constituent<T>>(){
            {
                this.add(Crystal.this.constituents.get(0));
            }
        };
        ArrayList<Constituent> arrayList2 = new ArrayList<Constituent>();
        while (!arrayList.isEmpty()) {
            Constituent constituent = (Constituent)arrayList.get(0);
            arrayList.remove(constituent);
            arrayList2.add(constituent);
            for (Constituent constituent2 : this.getNeighbors(constituent)) {
                if (arrayList.contains(constituent2) || arrayList2.contains(constituent2)) continue;
                arrayList.add(constituent2);
            }
        }
        return arrayList2.size() == this.constituents.size();
    }

    private ItemList<Constituent<T>> getNeighbors(Constituent<T> constituent) {
        ItemList<Constituent<Constituent<T>>> itemList = new ItemList<Constituent<Constituent<T>>>();
        for (ImmutableVector2D immutableVector2D : new ImmutableVector2D[]{this.northUnitVector, this.southUnitVector, this.eastUnitVector, this.westUnitVector}) {
            Option<Constituent<T>> option = this.getConstituentAtLocation(constituent.relativePosition.plus(immutableVector2D));
            if (!option.isSome()) continue;
            itemList.add(option.get());
        }
        return itemList;
    }

    private int getNumBonds(Constituent<T> constituent) {
        return this.getNeighbors(constituent).size();
    }
}

