/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.IUpdateStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.Motionless;
import java.awt.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Particle {
    private final Property<ImmutableVector2D> position;
    public final Property<ImmutableVector2D> velocity;
    private IUpdateStrategy updateStrategy = new Motionless();
    private boolean hasSubmerged = false;

    public Particle(ImmutableVector2D immutableVector2D) {
        this.position = new Property<ImmutableVector2D>(immutableVector2D);
        this.velocity = new Property<ImmutableVector2D>(new ImmutableVector2D());
    }

    public void stepInTime(ImmutableVector2D immutableVector2D, double d) {
        this.velocity.set(this.velocity.get().plus(immutableVector2D.times(d)));
        this.setPosition(this.position.get().plus(this.velocity.get().times(d)));
    }

    public void setPosition(ImmutableVector2D immutableVector2D) {
        this.position.set(immutableVector2D);
    }

    public void translate(ImmutableVector2D immutableVector2D) {
        this.translate(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public void translate(double d, double d2) {
        this.setPosition(this.position.get().plus(d, d2));
    }

    public abstract Shape getShape();

    public ImmutableVector2D getPosition() {
        return this.position.get();
    }

    public void addPositionObserver(VoidFunction1<ImmutableVector2D> voidFunction1) {
        this.position.addObserver(voidFunction1);
    }

    public boolean hasSubmerged() {
        return this.hasSubmerged;
    }

    public void setSubmerged() {
        this.hasSubmerged = true;
    }

    public void setUpdateStrategy(IUpdateStrategy iUpdateStrategy) {
        this.updateStrategy = iUpdateStrategy;
    }

    public void stepInTime(double d) {
        this.updateStrategy.stepInTime(this, d);
    }

    public double getDistance(Particle particle) {
        return this.getPosition().getDistance(particle.getPosition());
    }
}

