/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Beaker;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Dispenser;
import edu.colorado.phet.sugarandsaltsolutions.common.model.DispenserType;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SugarAndSaltSolutionModel;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarDispenserNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SugarDispenser<T extends SugarAndSaltSolutionModel>
extends Dispenser<T> {
    public final Property<Boolean> open = new Property<Boolean>(false);
    public final Random random = new Random();
    private boolean translating = false;
    private final ArrayList<ImmutableVector2D> positions = new ArrayList();
    public final T model;

    public SugarDispenser(double d, double d2, Beaker beaker, ObservableProperty<Boolean> observableProperty, String string, double d3, ObservableProperty<DispenserType> observableProperty2, DispenserType dispenserType, T t) {
        super(d, d2, 1.2, beaker, observableProperty, string, d3, observableProperty2, dispenserType, t);
        this.model = t;
    }

    @Override
    public void translate(Dimension2D dimension2D) {
        super.translate(dimension2D);
        this.setTranslating(true);
    }

    private void setTranslating(boolean bl) {
        this.translating = bl;
        this.open.set(bl);
    }

    @Override
    public void updateModel() {
        this.positions.add((ImmutableVector2D)this.center.get());
        while (this.positions.size() > 8) {
            this.positions.remove(0);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.positions.size() - 1; ++i) {
            ImmutableVector2D immutableVector2D = this.positions.get(i);
            ImmutableVector2D immutableVector2D2 = this.positions.get(i + 1);
            arrayList.add(immutableVector2D.minus(immutableVector2D2).getMagnitude());
        }
        double d = 0.0;
        for (Double d2 : arrayList) {
            d += d2.doubleValue();
        }
        double d3 = d / (double)arrayList.size() * this.distanceScale;
        this.setTranslating(d3 > 1.0E-5);
        double d4 = 2.0;
        double d5 = 1.2;
        double d6 = this.translating ? d4 : d5;
        double d7 = 0.0;
        double d8 = 0.25;
        if (d6 > (Double)this.angle.get()) {
            d7 = d8;
        } else if (d6 < (Double)this.angle.get()) {
            d7 = -d8;
        }
        double d9 = (Double)this.angle.get() + d7;
        if (d9 > d4) {
            d9 = d4;
        }
        if (d9 < d5) {
            d9 = d5;
        }
        this.angle.set(d9);
        if (((Boolean)this.enabled.get()).booleanValue() && this.translating && (Double)this.angle.get() > 1.5707963267948966 && ((Boolean)this.moreAllowed.get()).booleanValue()) {
            int n = MathUtil.clamp(1, (int)d3 * 5, 5);
            for (int i = 0; i < n; ++i) {
                ImmutableVector2D immutableVector2D = ((ImmutableVector2D)this.center.get()).plus(ImmutableVector2D.createPolar(this.dispenserHeight / 2.0 * 0.85, (Double)this.angle.get() + 1.9320794819577227 + Math.PI));
                this.addSugarToModel(immutableVector2D);
            }
        }
    }

    protected abstract void addSugarToModel(ImmutableVector2D var1);

    @Override
    public PNode createNode(ModelViewTransform modelViewTransform, boolean bl, Function1<Point2D, Point2D> function1) {
        return new SugarDispenserNode(modelViewTransform, this, bl, function1);
    }

    @Override
    public void reset() {
        super.reset();
        this.translating = false;
        this.positions.clear();
    }
}

