/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.common.view;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.RichSimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Solution;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.umd.cs.piccolo.PNode;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VolumeIndicatorNode
extends PNode {
    public VolumeIndicatorNode(final ModelViewTransform modelViewTransform, final Solution solution, ObservableProperty<Boolean> observableProperty, final ObservableProperty<Boolean> observableProperty2, final Function1<Double, String> function1) {
        observableProperty.addObserver(new VoidFunction1<Boolean>(){

            @Override
            public void apply(Boolean bl) {
                VolumeIndicatorNode.this.setVisible(bl);
            }
        });
        this.addChild(new HTMLNode(){
            {
                new RichSimpleObserver(){

                    public void update() {
                        String string = (String)function1.apply(solution.volume.get());
                        this.setHTML(MessageFormat.format((Boolean)observableProperty2.get() != false ? SugarAndSaltSolutionsResources.Strings.PATTERN__LITERS_SOLUTION : SugarAndSaltSolutionsResources.Strings.PATTERN__LITERS_WATER, string));
                    }
                }.observe(solution.volume, observableProperty2);
                this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
            }
        });
        solution.shape.addObserver(new VoidFunction1<Shape>(){

            @Override
            public void apply(Shape shape) {
                Rectangle2D rectangle2D = modelViewTransform.modelToView(shape).getBounds2D();
                VolumeIndicatorNode.this.setOffset(rectangle2D.getX() + 5.0, rectangle2D.getY() + 5.0);
            }
        });
    }
}

