/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.macro.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import java.awt.geom.Line2D;
import java.util.ArrayList;

public class MacroCrystal {
    public final double mass = 1.0E-6;
    public final Property<ImmutableVector2D> position;
    public final Property<ImmutableVector2D> velocity = new Property<ImmutableVector2D>(new ImmutableVector2D(0.0, 0.0));
    public final Property<ImmutableVector2D> acceleration = new Property<ImmutableVector2D>(new ImmutableVector2D(0.0, 0.0));
    private final ArrayList<VoidFunction0> removalListeners = new ArrayList();
    private final double moles;
    private boolean landed = false;
    public final double length;

    public MacroCrystal(ImmutableVector2D immutableVector2D, double d, double d2) {
        this.position = new Property<ImmutableVector2D>(immutableVector2D);
        this.moles = d;
        double d3 = d2 * d;
        this.length = Math.pow(d3, 0.3333333333333333);
    }

    public void stepInTime(ImmutableVector2D immutableVector2D, double d, Line2D.Double double_, Line2D.Double double_2, Line2D.Double double_3, Line2D.Double double_4) {
        if (!this.landed) {
            Line2D.Double double_5;
            ImmutableVector2D immutableVector2D2 = this.position.get();
            this.acceleration.set(immutableVector2D.times(1000000.0));
            this.velocity.set(this.velocity.get().plus(this.acceleration.get().times(d)));
            this.position.set(this.position.get().plus(this.velocity.get().times(d)));
            Line2D.Double double_6 = new Line2D.Double(immutableVector2D2.toPoint2D(), this.position.get().toPoint2D());
            if (double_6.intersectsLine(double_) || double_6.intersectsLine(double_2)) {
                this.velocity.set(new ImmutableVector2D(Math.abs(this.velocity.get().getX()), this.velocity.get().getY()));
                this.position.set(immutableVector2D2);
                this.position.set(this.position.get().plus(this.velocity.get().times(d)));
            }
            if ((double_5 = new Line2D.Double(immutableVector2D2.toPoint2D(), this.position.get().toPoint2D())).intersectsLine(double_3)) {
                this.position.set(new ImmutableVector2D(this.position.get().getX(), 0.0));
                this.landed = true;
            } else if (double_5.intersectsLine(double_4)) {
                this.position.set(new ImmutableVector2D(this.position.get().getX(), double_4.getY1() - 1.0E-6));
                this.landed = true;
            }
        }
    }

    public boolean isLanded() {
        return this.landed;
    }

    public void addRemovalListener(VoidFunction0 voidFunction0) {
        this.removalListeners.add(voidFunction0);
    }

    public void removeRemovalListener(VoidFunction0 voidFunction0) {
        this.removalListeners.remove(voidFunction0);
    }

    public void remove() {
        for (VoidFunction0 voidFunction0 : this.removalListeners) {
            voidFunction0.apply();
        }
    }

    public double getMoles() {
        return this.moles;
    }
}

