/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model;

import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.doubleproperty.CompositeDoubleProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Units;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IonConcentration
extends CompositeDoubleProperty {
    public IonConcentration(final MicroModel microModel, final Class<? extends Particle> clazz) {
        super(new Function0<Double>(){

            @Override
            public Double apply() {
                return (Double)microModel.waterVolume.get() == 0.0 ? 0.0 : Units.numberToMoles(microModel.freeParticles.count(clazz)) / (Double)microModel.waterVolume.get();
            }
        }, (ObservableProperty<?>[])new ObservableProperty[]{microModel.waterVolume});
        VoidFunction1<Particle> voidFunction1 = new VoidFunction1<Particle>(){

            @Override
            public void apply(Particle particle) {
                IonConcentration.this.notifyIfChanged();
            }
        };
        microModel.freeParticles.addElementAddedObserver(voidFunction1);
        microModel.freeParticles.addElementRemovedObserver(voidFunction1);
    }
}

