/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.RandomUtil;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride.CalciumChlorideCrystal;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.calciumchloride.ThreeParticleFormulaUnit;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalGrowth;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystalStrategy;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.IFormulaUnit;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalciumChlorideCrystalGrowth
extends CrystalGrowth<SphericalParticle, CalciumChlorideCrystal> {
    public CalciumChlorideCrystalGrowth(MicroModel microModel, ItemList<CalciumChlorideCrystal> itemList) {
        super(microModel, itemList);
    }

    @Override
    protected ArrayList<IFormulaUnit> getAllSeeds() {
        ItemList<Particle> itemList = this.model.freeParticles.filter(SphericalParticle.Calcium.class);
        ItemList<Particle> itemList2 = this.model.freeParticles.filter(SphericalParticle.Chloride.class);
        ArrayList<IFormulaUnit> arrayList = new ArrayList<IFormulaUnit>();
        for (Particle particle : itemList) {
            for (Particle particle2 : itemList2) {
                for (Particle particle3 : itemList2) {
                    if (particle2 == particle3) continue;
                    arrayList.add(new ThreeParticleFormulaUnit<Particle>(particle, particle2, particle3));
                }
            }
        }
        return arrayList;
    }

    @Override
    protected CalciumChlorideCrystal newCrystal(ImmutableVector2D immutableVector2D) {
        return new CalciumChlorideCrystal(immutableVector2D, RandomUtil.randomAngle()){
            {
                this.setUpdateStrategy(new CrystalStrategy(CalciumChlorideCrystalGrowth.this.model, ((CalciumChlorideCrystalGrowth)CalciumChlorideCrystalGrowth.this).model.calciumChlorideCrystals, ((CalciumChlorideCrystalGrowth)CalciumChlorideCrystalGrowth.this).model.calciumChlorideSaturated));
            }
        };
    }
}

