/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.logging.LoggingUtils;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.OpenSite;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.CrystallizationMatch;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.IFormulaUnit;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.TargetConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Random;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrystalGrowth<T extends Particle, U extends Crystal<T>> {
    private double lastNewCrystalFormationTime;
    protected final MicroModel model;
    private final ItemList<U> crystals;
    private final Random random = new Random();
    private static final Logger LOGGER = LoggingUtils.getLogger(CrystalGrowth.class.getCanonicalName());

    public CrystalGrowth(MicroModel microModel, ItemList<U> itemList) {
        this.model = microModel;
        this.crystals = itemList;
    }

    public void allowCrystalGrowth(double d, ObservableProperty<Boolean> observableProperty) {
        boolean bl;
        double d2 = this.model.getTime() - this.lastNewCrystalFormationTime;
        boolean bl2 = bl = d2 > 0.1 || this.model.isWaterBelowCrystalThreshold();
        if ((observableProperty.get().booleanValue() || this.model.isWaterBelowCrystalThreshold()) && bl) {
            this.lastNewCrystalFormationTime = this.model.getTime();
            if (this.crystals.size() == 0) {
                LOGGER.fine("No crystals, starting a new one, num crystals = " + this.crystals.size());
                this.towardNewCrystal(d);
            } else {
                Crystal crystal = (Crystal)this.crystals.get(this.random.nextInt(this.crystals.size()));
                TargetConfiguration<T> targetConfiguration = this.getTargetConfiguration(crystal);
                if (targetConfiguration != null) {
                    if (this.random.nextDouble() > 0.8 && this.crystals.size() <= 2) {
                        LOGGER.fine("Random choice to form new crystal instead of joining another");
                        this.towardNewCrystal(d);
                    } else if (targetConfiguration.distance <= 6.0E-10 * d * 1000.0) {
                        for (CrystallizationMatch crystallizationMatch : targetConfiguration.getMatches()) {
                            this.model.freeParticles.remove(crystallizationMatch.particle);
                            crystal.addConstituent(new Constituent(crystallizationMatch.particle, crystallizationMatch.site.relativePosition));
                        }
                    } else if (targetConfiguration.distance <= this.model.beaker.getWidth() / 2.0) {
                        for (CrystallizationMatch crystallizationMatch : targetConfiguration.getMatches()) {
                            ((Particle)crystallizationMatch.particle).velocity.set(crystallizationMatch.site.absolutePosition.minus(((Particle)crystallizationMatch.particle).getPosition()).getInstanceOfMagnitude(6.0E-10));
                        }
                    } else {
                        LOGGER.fine("Best match was too far away (" + targetConfiguration.distance / this.model.beaker.getWidth() + " beaker widths, so trying to form new crystal from lone ions");
                        this.towardNewCrystal(d);
                    }
                } else {
                    LOGGER.fine("No matches, starting a new crystal");
                    this.towardNewCrystal(d);
                }
            }
        }
    }

    public TargetConfiguration<T> getTargetConfiguration(Crystal<T> crystal) {
        ArrayList<CrystallizationMatch<T>> arrayList = new ArrayList<CrystallizationMatch<T>>();
        ArrayList<Particle> arrayList2 = new ArrayList<Particle>();
        ArrayList<ImmutableVector2D> arrayList3 = new ArrayList<ImmutableVector2D>();
        for (Class<? extends Particle> clazz : crystal.formula.getFormulaUnit()) {
            CrystallizationMatch<T> crystallizationMatch = this.findBestMatch(crystal, clazz, arrayList2, arrayList3);
            if (crystallizationMatch == null) {
                return null;
            }
            arrayList.add(crystallizationMatch);
            arrayList2.add((Particle)crystallizationMatch.particle);
            arrayList3.add(crystallizationMatch.site.relativePosition);
        }
        return new TargetConfiguration(new ItemList(arrayList));
    }

    private CrystallizationMatch<T> findBestMatch(Crystal<T> crystal, final Class<? extends Particle> clazz, final ArrayList<Particle> arrayList, final ArrayList<ImmutableVector2D> arrayList2) {
        ArrayList<CrystallizationMatch<Particle>> arrayList3 = new ArrayList<CrystallizationMatch<Particle>>();
        ItemList<Particle> itemList = this.model.freeParticles.filter(clazz).filter(new Function1<Particle, Boolean>(){

            @Override
            public Boolean apply(Particle particle) {
                return !arrayList.contains(particle);
            }
        });
        ItemList<OpenSite<T>> itemList2 = crystal.getOpenSites().filter(new Function1<OpenSite<T>, Boolean>(){

            @Override
            public Boolean apply(OpenSite<T> openSite) {
                return openSite.matches(clazz) && !arrayList2.contains(openSite.relativePosition);
            }
        });
        for (Particle particle : itemList) {
            for (OpenSite openSite : itemList2) {
                arrayList3.add(new CrystallizationMatch<Particle>(particle, openSite));
            }
        }
        Collections.sort(arrayList3, new Comparator<CrystallizationMatch>(){

            @Override
            public int compare(CrystallizationMatch crystallizationMatch, CrystallizationMatch crystallizationMatch2) {
                return Double.compare(crystallizationMatch.distance, crystallizationMatch2.distance);
            }
        });
        if (arrayList3.size() == 0) {
            return null;
        }
        return (CrystallizationMatch)arrayList3.get(0);
    }

    private void towardNewCrystal(double d) {
        ArrayList<IFormulaUnit> arrayList = this.getAllSeeds();
        Collections.sort(arrayList, new Comparator<IFormulaUnit>(){

            @Override
            public int compare(IFormulaUnit iFormulaUnit, IFormulaUnit iFormulaUnit2) {
                return Double.compare(iFormulaUnit.getDistance(), iFormulaUnit2.getDistance());
            }
        });
        if (arrayList.size() > 0) {
            IFormulaUnit iFormulaUnit = arrayList.get(0);
            iFormulaUnit.moveTogether(d);
            if (iFormulaUnit.getDistance() <= d * 6.0E-10) {
                this.convertToCrystal(iFormulaUnit);
                this.lastNewCrystalFormationTime = this.model.getTime();
            }
        }
    }

    protected abstract ArrayList<IFormulaUnit> getAllSeeds();

    private void convertToCrystal(IFormulaUnit<T> iFormulaUnit) {
        Particle particle = (Particle)iFormulaUnit.getParticles().get(0);
        U u = this.newCrystal(particle.getPosition());
        for (Particle particle2 : iFormulaUnit.getParticles()) {
            if (((Compound)u).numberConstituents() == 0) {
                ((Crystal)u).addConstituent(new Constituent<Particle>(particle2, ImmutableVector2D.ZERO));
            } else {
                OpenSite<Particle> openSite = this.getBindingSite(u, particle2);
                if (openSite == null) {
                    LOGGER.fine("No available sites to bind to, this probably shouldn't have happened.");
                } else {
                    ((Crystal)u).addConstituent(new Constituent<Particle>(particle2, openSite.relativePosition));
                }
            }
            this.model.freeParticles.remove(particle2);
        }
        this.crystals.add(u);
    }

    private OpenSite<T> getBindingSite(U u, T t) {
        ItemList itemList = ((Crystal)u).getOpenSites();
        Collections.shuffle(itemList);
        OpenSite openSite = null;
        for (OpenSite openSite2 : itemList) {
            if (!openSite2.matches((Particle)t)) continue;
            openSite = openSite2;
            break;
        }
        return openSite;
    }

    protected abstract U newCrystal(ImmutableVector2D var1);
}

