/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.OpenSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrystallizationMatch<T extends Particle> {
    public final T particle;
    public final OpenSite<T> site;
    public final double distance;

    public CrystallizationMatch(T t, OpenSite<T> openSite) {
        this.particle = t;
        this.site = openSite;
        this.distance = ((Particle)t).getPosition().minus(openSite.absolutePosition).getMagnitude();
    }

    public String toString() {
        return "CrystallizationMatch{particle=" + this.particle + ", constituent=" + this.site + ", distance=" + this.distance + '}';
    }
}

