/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.UpdateStrategy;

public class FlowOutOfDrainStrategy
extends UpdateStrategy {
    public FlowOutOfDrainStrategy(MicroModel microModel) {
        super(microModel);
    }

    public void stepInTime(Particle particle, double d) {
        particle.stepInTime(this.model.getExternalForce(false).times(1.0E-10), d);
        if (particle.getPosition().getY() < -3.0 * this.model.beaker.getHeight()) {
            if (particle instanceof Compound) {
                this.model.removeComponents((Compound)particle);
            } else if (particle instanceof SphericalParticle) {
                this.model.sphericalParticles.remove(particle);
            } else {
                new RuntimeException("No match found").printStackTrace();
            }
            this.model.drainedParticles.remove(particle);
        }
    }
}

