/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.MicroModel;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.dynamics.FlowToDrainStrategy;

public class RandomMotionWhileDraining {
    private final MicroModel model;

    public RandomMotionWhileDraining(MicroModel microModel) {
        this.model = microModel;
    }

    public void apply() {
        ImmutableVector2D immutableVector2D = this.model.getDrainFaucetMetrics().getInputPoint();
        for (Particle particle : this.model.freeParticles) {
            ImmutableVector2D immutableVector2D2 = new ImmutableVector2D(particle.getPosition(), immutableVector2D).getInstanceOfMagnitude(6.0E-10).times(this.getRelativeSpeed(immutableVector2D, particle));
            particle.setUpdateStrategy(new FlowToDrainStrategy(this.model, immutableVector2D2, true));
        }
    }

    private double getRelativeSpeed(ImmutableVector2D immutableVector2D, Particle particle) {
        double d = Math.max(0.25, particle.getPosition().getDistance(immutableVector2D) / this.model.beaker.getWidth());
        return 1.0 / d / d * (Double)this.model.outputFlowRate.get() / 2.0;
    }
}

