/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Crystal;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Formula;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.water.model.SaltIon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodiumChlorideCrystal
extends Crystal<SaltIon> {
    public SodiumChlorideCrystal(ImmutableVector2D immutableVector2D, double d) {
        super(new Formula(SaltIon.SodiumIon.class, SaltIon.ChlorideIon.class), immutableVector2D, new SphericalParticle.Chloride().radius + new SphericalParticle.Sodium().radius, d);
    }

    @Override
    public SaltIon createConstituentParticle(Class<? extends Particle> clazz) {
        return clazz == SaltIon.SodiumIon.class ? new SaltIon(new SphericalParticle.Sodium(), SugarAndSaltSolutionsResources.Strings.SODIUM) : new SaltIon(new SphericalParticle.Chloride(), SugarAndSaltSolutionsResources.Strings.CHLORIDE);
    }

    @Override
    public SaltIon createPartner(SaltIon saltIon) {
        return saltIon instanceof SaltIon.SodiumIon ? new SaltIon.ChlorideIon() : new SaltIon.SodiumIon();
    }
}

