/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.model;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.clock.ConstantDtClock;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Pair;
import edu.colorado.phet.common.phetcommon.util.function.Function1;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.sugarandsaltsolutions.common.model.AbstractSugarAndSaltSolutionsModel;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.ItemList;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Particle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.Sucrose;
import edu.colorado.phet.sugarandsaltsolutions.water.model.Box2DAdapter;
import edu.colorado.phet.sugarandsaltsolutions.water.model.SaltIon;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterMolecule;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Random;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WaterModel
extends AbstractSugarAndSaltSolutionsModel {
    public final ItemList<WaterMolecule> waterList = new ItemList();
    public final ItemList<Sucrose> sucroseList = new ItemList();
    public final ItemList<SaltIon> saltIonList = new ItemList();
    private final ArrayList<VoidFunction0> frameListeners = new ArrayList();
    public final World world;
    private final Random random = new Random();
    private final double particleWindowWidth = 1.84E-9;
    private final double particleWindowHeight = 1.196E-9;
    public final ImmutableRectangle2D particleWindow = new ImmutableRectangle2D(-9.2E-10, -5.98E-10, 1.84E-9, 1.196E-9);
    public final ImmutableRectangle2D waterBoundary = WaterModel.expand(this.particleWindow, WaterModel.getHalfDiagonal(new WaterMolecule().getShape().getBounds2D()));
    public final ImmutableRectangle2D sucroseBoundary = WaterModel.expand(this.particleWindow, WaterModel.getHalfDiagonal(new Sucrose().getShape().getBounds2D()));
    public final ImmutableRectangle2D chlorideBoundary = WaterModel.expand(this.particleWindow, WaterModel.getHalfDiagonal(new SaltIon.ChlorideIon().getShape().getBounds2D()));
    private static final double SALT_ION_DISTANCE_THRESHOLD = new SaltIon.ChlorideIon().getShape().getBounds2D().getWidth() * 1.3;
    private static final double SUCROSE_DISTANCE_THRESHOLD = new Sucrose().getShape().getBounds2D().getWidth();
    public final double COULOMB_FORCE_SCALE_FACTOR = 1.0E-36;
    private final boolean debugWaterRemoval = false;
    private final double box2DWidth = 20.0;
    final double scaleFactor;
    public final ModelViewTransform modelToBox2D;
    public final Property<Boolean> showWaterCharges;
    public final Property<Boolean> showSugarPartialCharge;
    public final Property<Boolean> showSugarAtoms;
    public final ObservableProperty<Boolean> showChargeColor;
    public final Property<Double> coulombStrengthMultiplier;
    public final Property<Double> pow;
    public final Property<Integer> randomness;
    public final Property<Double> probabilityOfInteraction;
    public final Property<Double> timeScale;
    public final Property<Integer> iterations;
    public final Property<Integer> overlaps;
    public final double MIN_COULOMB_DISTANCE;
    private final ItemList<Box2DAdapter> box2DAdapters;
    private final boolean useDebugDraw = false;
    private final HashMap<Compound<SphericalParticle>, Integer> deletedWaterCount;
    public final VoidFunction1<Sucrose> addSucrose;
    public final VoidFunction1<Sucrose> removeSucrose;
    public final VoidFunction1<SaltIon> addSaltIon;
    public final VoidFunction1<SaltIon> removeSaltIon;

    private static ImmutableRectangle2D expand(ImmutableRectangle2D immutableRectangle2D, double d) {
        return new ImmutableRectangle2D(immutableRectangle2D.x - d, immutableRectangle2D.y - d, immutableRectangle2D.width + d * 2.0, immutableRectangle2D.height + d * 2.0);
    }

    private static double getHalfDiagonal(Rectangle2D rectangle2D) {
        return new ImmutableVector2D(new Point2D.Double(rectangle2D.getX(), rectangle2D.getY()), new Point2D.Double(rectangle2D.getCenterX(), rectangle2D.getCenterY())).getMagnitude();
    }

    public WaterModel() {
        super(new ConstantDtClock(30.0));
        this.scaleFactor = 20.0 / this.particleWindow.width;
        this.modelToBox2D = ModelViewTransform.createSinglePointScaleMapping(new Point(), new Point(), this.scaleFactor);
        this.showWaterCharges = new Property<Boolean>(false);
        this.showSugarPartialCharge = new Property<Boolean>(false);
        this.showSugarAtoms = new Property<Boolean>(false);
        this.showChargeColor = new Property<Boolean>(false);
        this.coulombStrengthMultiplier = new Property<Double>(100.0);
        this.pow = new Property<Double>(2.0);
        this.randomness = new Property<Integer>(5);
        this.probabilityOfInteraction = new Property<Double>(0.6);
        this.timeScale = new Property<Double>(0.06);
        this.iterations = new Property<Integer>(100);
        this.overlaps = new Property<Integer>(10);
        this.MIN_COULOMB_DISTANCE = new WaterMolecule.Hydrogen().radius * 2.0;
        this.box2DAdapters = new ItemList();
        this.useDebugDraw = false;
        this.deletedWaterCount = new HashMap();
        this.addSucrose = new VoidFunction1<Sucrose>(){

            @Override
            public void apply(Sucrose sucrose) {
                WaterModel.this.addSucroseMolecule(sucrose);
            }
        };
        this.removeSucrose = new VoidFunction1<Sucrose>(){

            @Override
            public void apply(Sucrose sucrose) {
                WaterModel.this.removeSucrose(sucrose);
            }
        };
        this.addSaltIon = new VoidFunction1<SaltIon>(){

            @Override
            public void apply(SaltIon saltIon) {
                WaterModel.this.addSaltIon(saltIon);
            }
        };
        this.removeSaltIon = new VoidFunction1<SaltIon>(){

            @Override
            public void apply(SaltIon saltIon) {
                WaterModel.this.removeSaltIon(saltIon);
            }
        };
        this.world = new World(new Vec2(0.0f, 0.0f), true);
        this.initModel();
    }

    private void addWaterParticles() {
        for (int i = 0; i < 130; ++i) {
            this.addWaterMolecule(this.randomBetweenMinusOneAndOne() * this.particleWindow.width / 2.0, this.randomBetweenMinusOneAndOne() * this.particleWindow.height / 2.0, this.random.nextDouble() * Math.PI * 2.0);
        }
    }

    private double randomBetweenMinusOneAndOne() {
        return ((double)this.random.nextFloat() - 0.5) * 2.0;
    }

    public void addWaterMolecule(double d, double d2, double d3) {
        WaterMolecule waterMolecule = new WaterMolecule(new ImmutableVector2D(d, d2), d3);
        this.waterList.add(waterMolecule);
        this.box2DAdapters.add(new Box2DAdapter(this.world, waterMolecule, this.modelToBox2D));
    }

    @Override
    protected double updateModel(double d) {
        Serializable serializable;
        for (Box2DAdapter object2 : this.box2DAdapters) {
            if (!(this.random.nextDouble() < this.probabilityOfInteraction.get())) continue;
            for (SphericalParticle sphericalParticle : object2.compound) {
                for (SphericalParticle sphericalParticle2 : this.getAllParticles()) {
                    if (object2.compound.containsParticle(sphericalParticle2)) continue;
                    serializable = this.getCoulombForce(sphericalParticle2, sphericalParticle).times(1.0E-36);
                    object2.applyModelForce((ImmutableVector2D)serializable, sphericalParticle.getPosition());
                }
            }
        }
        final ItemList<Pair<SaltIon, SaltIon>> itemList = this.getSaltIonPairs().filter(new Function1<Pair<SaltIon, SaltIon>, Boolean>(){

            @Override
            public Boolean apply(Pair<SaltIon, SaltIon> pair) {
                return ((SaltIon)pair._1).getDistance((Particle)pair._2) < SALT_ION_DISTANCE_THRESHOLD;
            }
        });
        final ItemList<Pair<Sucrose, Sucrose>> itemList2 = this.getSucrosePairs().filter(new Function1<Pair<Sucrose, Sucrose>, Boolean>(){

            @Override
            public Boolean apply(Pair<Sucrose, Sucrose> pair) {
                return ((Sucrose)pair._1).getDistance((Particle)pair._2) < SUCROSE_DISTANCE_THRESHOLD;
            }
        });
        ArrayList<Pair<? extends Compound<SphericalParticle>, ? extends Compound<SphericalParticle>>> arrayList = new ArrayList<Pair<? extends Compound<SphericalParticle>, ? extends Compound<SphericalParticle>>>(){
            {
                this.addAll(itemList);
                this.addAll(itemList2);
            }
        };
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            if (!(box2DAdapter.compound instanceof WaterMolecule)) continue;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                serializable = (Pair)iterator.next();
                ImmutableVector2D immutableVector2D = ((Compound)((Pair)serializable)._1).getPosition();
                ImmutableVector2D immutableVector2D2 = ((Compound)((Pair)serializable)._2).getPosition();
                ImmutableVector2D immutableVector2D3 = immutableVector2D.plus(immutableVector2D2).times(0.5);
                ImmutableVector2D immutableVector2D4 = box2DAdapter.getModelPosition();
                double d2 = 1.0;
                ImmutableVector2D immutableVector2D5 = this.getCoulombForce(immutableVector2D3, immutableVector2D4, d2, -d2).times(1.0E-36);
                box2DAdapter.applyModelForce(immutableVector2D5, immutableVector2D4);
            }
        }
        this.subtractOutCenterOfMomentum();
        this.world.step((float)(d * this.timeScale.get()), this.iterations.get(), this.iterations.get());
        this.applyPeriodicBoundaryConditions();
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            box2DAdapter.worldStepped();
        }
        for (VoidFunction0 voidFunction0 : this.frameListeners) {
            voidFunction0.apply();
        }
        return 0.0;
    }

    private ItemList<Pair<SaltIon, SaltIon>> getSaltIonPairs() {
        return new ItemList<Pair<SaltIon, SaltIon>>(){
            {
                for (SaltIon saltIon : WaterModel.this.saltIonList) {
                    for (SaltIon saltIon2 : WaterModel.this.saltIonList) {
                        if (saltIon == saltIon2) continue;
                        this.add(new Pair<SaltIon, SaltIon>(saltIon, saltIon2));
                    }
                }
            }
        };
    }

    private ItemList<Pair<Sucrose, Sucrose>> getSucrosePairs() {
        return new ItemList<Pair<Sucrose, Sucrose>>(){
            {
                for (Sucrose sucrose : WaterModel.this.sucroseList) {
                    for (Sucrose sucrose2 : WaterModel.this.sucroseList) {
                        if (sucrose == sucrose2) continue;
                        this.add(new Pair<Sucrose, Sucrose>(sucrose, sucrose2));
                    }
                }
            }
        };
    }

    private Iterable<? extends SphericalParticle> getAllParticles() {
        return new ArrayList<SphericalParticle>(){
            {
                for (WaterMolecule compound : WaterModel.this.waterList) {
                    for (SphericalParticle sphericalParticle : compound) {
                        this.add(sphericalParticle);
                    }
                }
                for (Sucrose sucrose : WaterModel.this.sucroseList) {
                    for (SphericalParticle sphericalParticle : sucrose) {
                        this.add(sphericalParticle);
                    }
                }
                for (SaltIon saltIon : WaterModel.this.saltIonList) {
                    for (SphericalParticle sphericalParticle : saltIon) {
                        this.add(sphericalParticle);
                    }
                }
            }
        };
    }

    private ImmutableVector2D getCoulombForce(SphericalParticle sphericalParticle, SphericalParticle sphericalParticle2) {
        return this.getCoulombForce(sphericalParticle.getPosition(), sphericalParticle2.getPosition(), sphericalParticle.getCharge(), sphericalParticle2.getCharge());
    }

    private ImmutableVector2D getCoulombForce(ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2, double d, double d2) {
        if (immutableVector2D.equals(immutableVector2D2)) {
            return ImmutableVector2D.ZERO;
        }
        double d3 = immutableVector2D.getDistance(immutableVector2D2);
        if (d3 < this.MIN_COULOMB_DISTANCE) {
            d3 = this.MIN_COULOMB_DISTANCE;
        }
        double d4 = 8.987E9 * d * d2 / Math.pow(d3, this.pow.get()) / d3 * this.coulombStrengthMultiplier.get();
        return new ImmutableVector2D((immutableVector2D2.getX() - immutableVector2D.getX()) * d4, (immutableVector2D2.getY() - immutableVector2D.getY()) * d4);
    }

    private void subtractOutCenterOfMomentum() {
        Vec2 vec2 = this.getBox2DMomentum();
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            Vec2 vec22 = box2DAdapter.body.getLinearVelocity();
            Vec2 vec23 = vec2.mul((float)(-1.0 / this.getBox2DMass()));
            box2DAdapter.body.setLinearVelocity(vec22.add(vec23));
        }
    }

    private Vec2 getBox2DMomentum() {
        Vec2 vec2 = new Vec2();
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            Vec2 vec22 = box2DAdapter.body.getLinearVelocity();
            vec2.x += vec22.x * box2DAdapter.body.getMass();
            vec2.y += vec22.y * box2DAdapter.body.getMass();
        }
        return vec2;
    }

    private double getBox2DMass() {
        double d = 0.0;
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            d += (double)box2DAdapter.body.getMass();
        }
        return d;
    }

    private void applyPeriodicBoundaryConditions() {
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            Compound<SphericalParticle> compound = box2DAdapter.compound;
            double d = compound.getPosition().getX();
            double d2 = compound.getPosition().getY();
            ImmutableRectangle2D immutableRectangle2D = this.getBoundary(box2DAdapter.compound);
            double d3 = immutableRectangle2D.width / 100.0;
            if (compound.getPosition().getX() > immutableRectangle2D.getMaxX()) {
                box2DAdapter.setModelPosition(immutableRectangle2D.x + d3, d2);
                continue;
            }
            if (compound.getPosition().getX() < immutableRectangle2D.x) {
                box2DAdapter.setModelPosition(immutableRectangle2D.getMaxX() - d3, d2);
                continue;
            }
            if (compound.getPosition().getY() > immutableRectangle2D.getMaxY()) {
                box2DAdapter.setModelPosition(d, immutableRectangle2D.y + d3);
                continue;
            }
            if (!(compound.getPosition().getY() < immutableRectangle2D.y)) continue;
            box2DAdapter.setModelPosition(d, immutableRectangle2D.getMaxY() - d3);
        }
    }

    private ImmutableRectangle2D getBoundary(Compound<SphericalParticle> compound) {
        if (compound instanceof Sucrose) {
            return this.sucroseBoundary;
        }
        if (compound instanceof SaltIon.ChlorideIon) {
            return this.chlorideBoundary;
        }
        if (compound instanceof SaltIon.SodiumIon) {
            return this.chlorideBoundary;
        }
        if (compound instanceof WaterMolecule) {
            return this.waterBoundary;
        }
        throw new IllegalArgumentException("unknown type: " + compound.getClass());
    }

    public void reset() {
        this.initModel();
        this.showSugarAtoms.reset();
        this.showWaterCharges.reset();
        this.showSugarPartialCharge.reset();
        this.clockRunning.reset();
    }

    protected void initModel() {
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            this.world.destroyBody(box2DAdapter.body);
        }
        this.box2DAdapters.clear();
        this.waterList.clear();
        this.sucroseList.clear();
        this.saltIonList.clear();
        this.addWaterParticles();
    }

    public double getRandomX() {
        return (float)((double)this.random.nextFloat() * this.particleWindow.width - this.particleWindow.width / 2.0);
    }

    public double getRandomY() {
        return (float)((double)this.random.nextFloat() * this.particleWindow.height);
    }

    private void removeOverlappingWater(Compound<SphericalParticle> compound) {
        HashSet<WaterMolecule> hashSet = this.getOverlappingWaterMolecules(compound);
        this.waterList.removeAll(hashSet);
        ArrayList<Box2DAdapter> arrayList = this.getBox2DAdapters(hashSet);
        for (Box2DAdapter box2DAdapter : arrayList) {
            this.world.destroyBody(box2DAdapter.body);
            this.box2DAdapters.remove(box2DAdapter);
        }
        this.deletedWaterCount.put(compound, hashSet.size());
    }

    private ArrayList<Box2DAdapter> getBox2DAdapters(HashSet<WaterMolecule> hashSet) {
        ArrayList<Box2DAdapter> arrayList = new ArrayList<Box2DAdapter>();
        for (Box2DAdapter box2DAdapter : this.box2DAdapters) {
            if (!hashSet.contains(box2DAdapter.compound)) continue;
            arrayList.add(box2DAdapter);
        }
        return arrayList;
    }

    private HashSet<WaterMolecule> getOverlappingWaterMolecules(final Compound<SphericalParticle> compound) {
        return new HashSet<WaterMolecule>(){
            {
                IdentityHashMap<WaterMolecule, Integer> identityHashMap = new IdentityHashMap<WaterMolecule, Integer>();
                for (WaterMolecule waterMolecule : WaterModel.this.waterList) {
                    if (waterMolecule == compound) continue;
                    for (SphericalParticle sphericalParticle : waterMolecule) {
                        for (SphericalParticle sphericalParticle2 : compound) {
                            if (!(sphericalParticle.getPosition().getDistance(sphericalParticle2.getPosition()) < sphericalParticle.radius + sphericalParticle2.radius)) continue;
                            identityHashMap.put(waterMolecule, identityHashMap.get(waterMolecule) == null ? 1 : (Integer)identityHashMap.get(waterMolecule) + 1);
                        }
                    }
                }
                for (WaterMolecule waterMolecule : identityHashMap.keySet()) {
                    if ((Integer)identityHashMap.get(waterMolecule) < WaterModel.this.overlaps.get()) continue;
                    this.add(waterMolecule);
                }
            }
        };
    }

    public void addSucroseMolecule(Sucrose sucrose) {
        this.removeOverlappingWater(sucrose);
        this.sucroseList.add(sucrose);
        this.box2DAdapters.add(new Box2DAdapter(this.world, sucrose, this.modelToBox2D));
    }

    public void removeSucrose(final Sucrose sucrose) {
        if (this.sucroseList.contains(sucrose)) {
            ArrayList<Box2DAdapter> arrayList = this.box2DAdapters.filterToArrayList(new Function1<Box2DAdapter, Boolean>(){

                @Override
                public Boolean apply(Box2DAdapter box2DAdapter) {
                    return box2DAdapter.compound == sucrose;
                }
            });
            for (Box2DAdapter box2DAdapter : arrayList) {
                this.world.destroyBody(box2DAdapter.body);
                this.box2DAdapters.remove(box2DAdapter);
            }
            this.sucroseList.remove(sucrose);
            this.addWaterWhereSucroseWas(sucrose);
        }
    }

    private void addWaterWhereSucroseWas(Sucrose sucrose) {
        if (this.deletedWaterCount.containsKey(sucrose)) {
            int n = this.deletedWaterCount.get(sucrose);
            Rectangle2D rectangle2D = sucrose.getShape().getBounds2D();
            for (int i = 0; i < n; ++i) {
                this.addWaterMolecule(this.randomBetweenMinusOneAndOne() * rectangle2D.getWidth() + rectangle2D.getCenterX(), this.randomBetweenMinusOneAndOne() * rectangle2D.getHeight() + rectangle2D.getCenterY(), this.random.nextDouble() * 2.0 * Math.PI);
            }
            this.deletedWaterCount.remove(sucrose);
        }
    }

    public void addSaltIon(SaltIon saltIon) {
        this.saltIonList.add(saltIon);
        this.box2DAdapters.add(new Box2DAdapter(this.world, saltIon, this.modelToBox2D));
    }

    public void removeSaltIon(final SaltIon saltIon) {
        if (this.saltIonList.contains(saltIon)) {
            ArrayList<Box2DAdapter> arrayList = this.box2DAdapters.filterToArrayList(new Function1<Box2DAdapter, Boolean>(){

                @Override
                public Boolean apply(Box2DAdapter box2DAdapter) {
                    return box2DAdapter.compound == saltIon;
                }
            });
            for (Box2DAdapter box2DAdapter : arrayList) {
                this.world.destroyBody(box2DAdapter.body);
                this.box2DAdapters.remove(box2DAdapter);
            }
            this.saltIonList.remove(saltIon);
        }
    }
}

