/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableRectangle2D;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.model.Bucket;
import edu.colorado.phet.common.phetcommon.model.property.CompositeProperty;
import edu.colorado.phet.common.phetcommon.model.property.Not;
import edu.colorado.phet.common.phetcommon.model.property.ObservableProperty;
import edu.colorado.phet.common.phetcommon.model.property.Property;
import edu.colorado.phet.common.phetcommon.util.Option;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction0;
import edu.colorado.phet.common.phetcommon.util.function.VoidFunction1;
import edu.colorado.phet.common.phetcommon.view.Dimension2DDouble;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.nodes.BucketView;
import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.FloatingClockControlNode;
import edu.colorado.phet.sugarandsaltsolutions.GlobalState;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Compound;
import edu.colorado.phet.sugarandsaltsolutions.common.model.Constituent;
import edu.colorado.phet.sugarandsaltsolutions.common.model.SphericalParticle;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.Sucrose;
import edu.colorado.phet.sugarandsaltsolutions.common.model.sucrose.SucroseCrystal;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarAndSaltSolutionsCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.SugarAndSaltSolutionsResetAllButtonNode;
import edu.colorado.phet.sugarandsaltsolutions.micro.model.OpenSite;
import edu.colorado.phet.sugarandsaltsolutions.water.model.SaltIon;
import edu.colorado.phet.sugarandsaltsolutions.water.model.SodiumChlorideCrystal;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterModel;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterMolecule;
import edu.colorado.phet.sugarandsaltsolutions.water.view.CompoundListNode;
import edu.colorado.phet.sugarandsaltsolutions.water.view.MiniBeakerNode;
import edu.colorado.phet.sugarandsaltsolutions.water.view.ParticleWindowNode;
import edu.colorado.phet.sugarandsaltsolutions.water.view.SaltIonLabel;
import edu.colorado.phet.sugarandsaltsolutions.water.view.SphericalParticleNodeWithText;
import edu.colorado.phet.sugarandsaltsolutions.water.view.Sucrose3DDialog;
import edu.colorado.phet.sugarandsaltsolutions.water.view.SucroseLabel;
import edu.colorado.phet.sugarandsaltsolutions.water.view.WaterControlPanel;
import edu.colorado.phet.sugarandsaltsolutions.water.view.ZoomIndicatorNode;
import edu.umd.cs.piccolo.PNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class WaterCanvas
extends SugarAndSaltSolutionsCanvas {
    public static final Dimension canvasSize = new Dimension(1008, 676);
    private final ParticleWindowNode particleWindowNode;
    private final BucketView saltBucket;
    private final BucketView sugarBucket;
    private final PNode saltBucketParticleLayer;
    private final PNode sugarBucketParticleLayer;
    private final Sucrose3DDialog sucrose3DDialog;
    protected final ModelViewTransform transform;
    private final WaterModel model;
    private static final Color BUCKET_COLOR = Color.white;

    public WaterCanvas(final WaterModel waterModel, final GlobalState globalState) {
        this.model = waterModel;
        this.sucrose3DDialog = new Sucrose3DDialog(globalState.frame, BeakerAndShakerCanvas.WATER_COLOR);
        globalState.colorScheme.backgroundColorSet.color.addObserver(new VoidFunction1<Color>(){

            @Override
            public void apply(Color color) {
                WaterCanvas.this.setBackground(color);
            }
        });
        ImmutableRectangle2D immutableRectangle2D = waterModel.particleWindow;
        double d = canvasSize.getWidth() * 0.7;
        double d2 = waterModel.particleWindow.height * d / waterModel.particleWindow.width;
        this.transform = ModelViewTransform.createRectangleInvertedYMapping(immutableRectangle2D.toRectangle2D(), new Rectangle2D.Double(40.0, 40.0, d, d2));
        this.addWorldChild(this.rootNode);
        this.particleWindowNode = new ParticleWindowNode(waterModel, this.transform);
        this.rootNode.addChild(this.particleWindowNode);
        this.setWorldTransformStrategy(new PhetPCanvas.CenteredStage(this, canvasSize));
        MiniBeakerNode miniBeakerNode = new MiniBeakerNode(){
            {
                this.translate((canvasSize.getWidth() - this.getFullBounds().getWidth() - 40.0) / this.getScale(), 300.0);
            }
        };
        this.addChild(miniBeakerNode);
        this.addChild(new ZoomIndicatorNode(new CompositeProperty<Color>(new Function0<Color>(){

            @Override
            public Color apply() {
                return globalState.colorScheme.whiteBackground.get() != false ? Color.blue : Color.yellow;
            }
        }, globalState.colorScheme.whiteBackground), miniBeakerNode, this.particleWindowNode));
        final SugarAndSaltSolutionsResetAllButtonNode sugarAndSaltSolutionsResetAllButtonNode = new SugarAndSaltSolutionsResetAllButtonNode(WaterCanvas.canvasSize.width, WaterCanvas.canvasSize.height, new VoidFunction0(){

            public void apply() {
                waterModel.reset();
                WaterCanvas.this.addSaltToBucket();
                WaterCanvas.this.addSugarToBucket();
                WaterCanvas.this.sucrose3DDialog.reset();
            }
        });
        this.addChild(sugarAndSaltSolutionsResetAllButtonNode);
        WaterControlPanel waterControlPanel = new WaterControlPanel(waterModel, globalState, this, this.sucrose3DDialog){
            {
                super(waterModel, globalState, waterCanvas2, sucrose3DDialog);
                this.setOffset(canvasSize.getWidth() - 5.0 - this.getFullBounds().getWidth(), sugarAndSaltSolutionsResetAllButtonNode.getFullBounds().getY() - this.getFullBounds().getHeight() - 10.0);
            }
        };
        this.addChild(waterControlPanel);
        Rectangle rectangle = new Rectangle(0, 0, 1, 1);
        ModelViewTransform modelViewTransform = ModelViewTransform.createRectangleInvertedYMapping(rectangle, rectangle);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(205.0, 80.0);
        this.sugarBucket = new BucketView(new Bucket(40.0 + d / 2.0 + 105.0, -canvasSize.getHeight() + dimension2DDouble.getHeight(), dimension2DDouble, BUCKET_COLOR, SugarAndSaltSolutionsResources.Strings.SUGAR), modelViewTransform, Color.black, new PhetFont(22, true));
        this.saltBucket = new BucketView(new Bucket(40.0 + d / 2.0 - 105.0, -canvasSize.getHeight() + dimension2DDouble.getHeight(), dimension2DDouble, BUCKET_COLOR, SugarAndSaltSolutionsResources.Strings.SALT), modelViewTransform, Color.black, new PhetFont(22, true));
        this.addChild(this.sugarBucket.getHoleNode());
        this.addChild(this.saltBucket.getHoleNode());
        this.saltBucketParticleLayer = new PNode();
        this.addChild(this.saltBucketParticleLayer);
        this.addChild(this.saltBucket.getFrontNode());
        this.sugarBucketParticleLayer = new PNode();
        this.addChild(this.sugarBucketParticleLayer);
        this.addChild(this.sugarBucket.getFrontNode());
        this.sugarBucketParticleLayer.addPropertyChangeListener("children", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (WaterCanvas.this.sugarBucketParticleLayer.getChildrenCount() == 2) {
                    WaterCanvas.this.addSugarToBucket();
                }
            }
        });
        this.addChild(new FloatingClockControlNode(waterModel.clockRunning, NO_READOUT, waterModel.clock, "", new Property<Color>(Color.white)){
            {
                this.setOffset(5.0, canvasSize.getHeight() - this.getFullBounds().getHeight() - 5.0);
            }
        });
        waterModel.waterList.addElementAddedObserver(new VoidFunction1<WaterMolecule>(){

            @Override
            public void apply(final WaterMolecule waterMolecule) {
                for (SphericalParticle sphericalParticle : waterMolecule) {
                    final SphericalParticleNodeWithText sphericalParticleNodeWithText = new SphericalParticleNodeWithText(WaterCanvas.this.transform, sphericalParticle, waterModel.showChargeColor, waterModel.showWaterCharges);
                    ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.addChild(sphericalParticleNodeWithText);
                    waterModel.waterList.addElementRemovedObserver(waterMolecule, new VoidFunction0(){

                        public void apply() {
                            waterModel.waterList.removeElementRemovedObserver(waterMolecule, this);
                            ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.removeChild(sphericalParticleNodeWithText);
                        }
                    });
                }
            }
        });
        waterModel.sucroseList.addElementAddedObserver(new VoidFunction1<Sucrose>(){

            @Override
            public void apply(final Sucrose sucrose) {
                final CompoundListNode compoundListNode = new CompoundListNode(WaterCanvas.this.transform, waterModel, WaterCanvas.this.sugarBucket, WaterCanvas.this.sugarBucketParticleLayer, WaterCanvas.this, waterModel.addSucrose, waterModel.removeSucrose, (ObservableProperty)Not.not(waterModel.showSugarAtoms), (Option)new SucroseLabel(), true, waterModel.showSugarPartialCharge, (ObservableProperty)waterModel.clockRunning, (Compound[])new Sucrose[]{sucrose});
                compoundListNode.setIcon(false);
                compoundListNode.setInBucket(false);
                ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.addChild(compoundListNode);
                waterModel.sucroseList.addElementRemovedObserver(sucrose, new VoidFunction0(){

                    public void apply() {
                        waterModel.sucroseList.removeElementRemovedObserver(sucrose, this);
                        ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.removeChild(compoundListNode);
                    }
                });
            }
        });
        waterModel.saltIonList.addElementAddedObserver(new VoidFunction1<SaltIon>(){

            @Override
            public void apply(final SaltIon saltIon) {
                final CompoundListNode compoundListNode = new CompoundListNode(WaterCanvas.this.transform, waterModel, WaterCanvas.this.saltBucket, WaterCanvas.this.saltBucketParticleLayer, WaterCanvas.this, waterModel.addSaltIon, waterModel.removeSaltIon, waterModel.showChargeColor, (Option)new SaltIonLabel(), false, new Property<Boolean>(false), (ObservableProperty)waterModel.clockRunning, (Compound[])new SaltIon[]{saltIon});
                compoundListNode.setIcon(false);
                compoundListNode.setInBucket(false);
                ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.addChild(compoundListNode);
                waterModel.saltIonList.addElementRemovedObserver(saltIon, new VoidFunction0(){

                    public void apply() {
                        waterModel.saltIonList.removeElementRemovedObserver(saltIon, this);
                        ((WaterCanvas)WaterCanvas.this).particleWindowNode.particleLayer.removeChild(compoundListNode);
                    }
                });
            }
        });
        this.addSaltToBucket();
        this.addSugarToBucket();
        waterModel.addResetListener(new VoidFunction0(){

            public void apply() {
                WaterCanvas.this.addSaltToBucket();
                WaterCanvas.this.addSugarToBucket();
            }
        });
    }

    public void moduleActivated() {
        this.sucrose3DDialog.activate();
    }

    public void moduleDeactivated() {
        this.sucrose3DDialog.deactivate();
    }

    private void addSaltToBucket() {
        this.saltBucketParticleLayer.removeAllChildren();
        SodiumChlorideCrystal sodiumChlorideCrystal = new SodiumChlorideCrystal(ImmutableVector2D.ZERO, 0.0){
            {
                this.addConstituent(new Constituent<SaltIon.ChlorideIon>(new SaltIon.ChlorideIon(), ImmutableVector2D.ZERO));
                this.addConstituent(((OpenSite)this.getOpenSites().get(1)).toConstituent());
                this.addConstituent(((OpenSite)this.getOpenSites().get(2)).toConstituent());
                this.addConstituent(((OpenSite)this.getOpenSites().get(4)).toConstituent());
            }
        };
        CompoundListNode compoundListNode = new CompoundListNode(this.transform, this.model, this.saltBucket, this.saltBucketParticleLayer, this, this.model.addSaltIon, this.model.removeSaltIon, this.model.showChargeColor, (Option)new SaltIonLabel(), true, new Property<Boolean>(false), (ObservableProperty)this.model.clockRunning, (Compound[])sodiumChlorideCrystal.getConstituentParticleList().toArray(new SaltIon[sodiumChlorideCrystal.getConstituentParticleList().size()]));
        this.saltBucketParticleLayer.addChild(compoundListNode);
        compoundListNode.moveToBucket();
    }

    private void addSugarToBucket() {
        this.sugarBucketParticleLayer.removeAllChildren();
        SucroseCrystal sucroseCrystal = new SucroseCrystal(ImmutableVector2D.ZERO, 0.0){
            {
                this.addConstituent(new Constituent<Sucrose>(new Sucrose(ImmutableVector2D.ZERO, 1.5707963267948966), ImmutableVector2D.ZERO));
                this.addConstituent(new Constituent<Sucrose>(new Sucrose(ImmutableVector2D.ZERO, 1.5707963267948966), ((OpenSite)this.getOpenSites().get((int)2)).relativePosition));
            }
        };
        CompoundListNode compoundListNode = new CompoundListNode(this.transform, this.model, this.sugarBucket, this.sugarBucketParticleLayer, this, this.model.addSucrose, this.model.removeSucrose, (ObservableProperty)Not.not(this.model.showSugarAtoms), (Option)new SucroseLabel(), true, this.model.showSugarPartialCharge, (ObservableProperty)this.model.clockRunning, (Compound[])sucroseCrystal.getConstituentParticleList().toArray(new Sucrose[sucroseCrystal.getConstituentParticleList().size()]));
        this.sugarBucketParticleLayer.addChild(compoundListNode);
        compoundListNode.moveToBucket();
    }
}

