/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.sugarandsaltsolutions.water.view;

import edu.colorado.phet.common.phetcommon.model.property.SettableNot;
import edu.colorado.phet.common.phetcommon.model.property.SettableProperty;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.controls.PropertyCheckBox;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.common.piccolophet.nodes.PhetPText;
import edu.colorado.phet.common.piccolophet.nodes.TextButtonNode;
import edu.colorado.phet.common.piccolophet.nodes.layout.VBox;
import edu.colorado.phet.sugarandsaltsolutions.GlobalState;
import edu.colorado.phet.sugarandsaltsolutions.SugarAndSaltSolutionsResources;
import edu.colorado.phet.sugarandsaltsolutions.common.view.BeakerAndShakerCanvas;
import edu.colorado.phet.sugarandsaltsolutions.common.view.WhiteControlPanelNode;
import edu.colorado.phet.sugarandsaltsolutions.water.dev.DeveloperControlDialog;
import edu.colorado.phet.sugarandsaltsolutions.water.model.WaterModel;
import edu.colorado.phet.sugarandsaltsolutions.water.view.Sucrose3DDialog;
import edu.colorado.phet.sugarandsaltsolutions.water.view.WaterCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;

public class WaterControlPanel
extends WhiteControlPanelNode {
    public WaterControlPanel(final WaterModel waterModel, GlobalState globalState, final WaterCanvas waterCanvas, final Sucrose3DDialog sucrose3DDialog) {
        super(new VBox(new PhetPText(SugarAndSaltSolutionsResources.Strings.SHOW, BeakerAndShakerCanvas.TITLE_FONT), new PSwing(new VerticalLayoutPanel(){
            {
                this.add(new PropertyCheckBox(SugarAndSaltSolutionsResources.Strings.WATER_PARTIAL_CHARGES, waterModel.showWaterCharges){
                    {
                        this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                    }
                });
                this.add(new PropertyCheckBox(SugarAndSaltSolutionsResources.Strings.SUGAR_HIGHLIGHT, new SettableNot((SettableProperty<Boolean>)waterModel.showSugarAtoms)){
                    {
                        this.setFont(BeakerAndShakerCanvas.CONTROL_FONT);
                    }
                });
            }
        }), globalState.config.isDev() ? new TextButtonNode("Developer Controls"){
            {
                super(string);
                this.addActionListener(new ActionListener(){
                    DeveloperControlDialog dialog = null;

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (this.dialog == null) {
                            this.dialog = new DeveloperControlDialog(SwingUtilities.getWindowAncestor(waterCanvas), waterModel);
                            SwingUtils.centerInParent(this.dialog);
                        }
                        this.dialog.setVisible(true);
                    }
                });
            }
        } : new PNode(), new TextButtonNode(SugarAndSaltSolutionsResources.Strings.SUGAR_IN_3_D, BeakerAndShakerCanvas.CONTROL_FONT, Color.yellow){
            {
                super(string, font, color);
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        sucrose3DDialog.showDialog();
                    }
                });
            }
        }));
    }
}

