/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision.broadphase;

import java.util.Stack;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.TreeCallback;
import org.jbox2d.callbacks.TreeRayCastCallback;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.RayCastInput;
import org.jbox2d.collision.broadphase.DynamicTreeNode;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.IOrderedStack;
import org.jbox2d.pooling.OrderedStack;

public class DynamicTree {
    public static final int MAX_STACK_SIZE = 128;
    private DynamicTreeNode m_root = null;
    private int m_nodeCount = 0;
    private DynamicTreeNode lastLeaf = null;
    private int m_insertionCount = 0;
    private int m_path = 0;
    private final Stack<DynamicTreeNode> nodeStack = new Stack();
    private final Vec2[] drawVecs = new Vec2[4];
    private int nodeCounter = 0;
    private final Vec2 d = new Vec2();
    private final IOrderedStack<Vec2> vec2s = new OrderedStack<Vec2>(Vec2.class, 388, 10);
    private final AABB aabb = new AABB();
    private final RayCastInput subInput = new RayCastInput();
    private final Vec2 center = new Vec2();
    private final Vec2 delta1 = new Vec2();
    private final Vec2 delta2 = new Vec2();
    private final AABB oldAABB = new AABB();
    private final Color3f color = new Color3f();
    private final Vec2 textVec = new Vec2();

    public DynamicTree() {
        for (int i = 0; i < this.drawVecs.length; ++i) {
            this.drawVecs[i] = new Vec2();
        }
    }

    public final DynamicTreeNode createProxy(AABB aABB, Object object) {
        DynamicTreeNode dynamicTreeNode = this.allocateNode();
        dynamicTreeNode.aabb.lowerBound.x = aABB.lowerBound.x - Settings.aabbExtension;
        dynamicTreeNode.aabb.lowerBound.y = aABB.lowerBound.y - Settings.aabbExtension;
        dynamicTreeNode.aabb.upperBound.x = aABB.upperBound.x + Settings.aabbExtension;
        dynamicTreeNode.aabb.upperBound.y = aABB.upperBound.y + Settings.aabbExtension;
        dynamicTreeNode.userData = object;
        this.insertLeaf(dynamicTreeNode);
        int n = this.m_nodeCount >> 4;
        int n2 = this.computeHeight();
        for (int i = 0; n2 > 64 && i < 10; ++i) {
            this.rebalance(n);
            n2 = this.computeHeight();
        }
        return dynamicTreeNode;
    }

    public final void destroyProxy(DynamicTreeNode dynamicTreeNode) {
        assert (dynamicTreeNode != null);
        assert (dynamicTreeNode.isLeaf());
        this.removeLeaf(dynamicTreeNode);
        this.freeNode(dynamicTreeNode);
    }

    public final boolean moveProxy(DynamicTreeNode dynamicTreeNode, AABB aABB, Vec2 vec2) {
        assert (dynamicTreeNode != null);
        assert (dynamicTreeNode.isLeaf());
        if (dynamicTreeNode.aabb.contains(aABB)) {
            return false;
        }
        this.removeLeaf(dynamicTreeNode);
        aABB.lowerBound.x -= Settings.aabbExtension;
        aABB.lowerBound.y -= Settings.aabbExtension;
        aABB.upperBound.x += Settings.aabbExtension;
        aABB.upperBound.y += Settings.aabbExtension;
        this.d.set(vec2).mulLocal(Settings.aabbMultiplier);
        if (this.d.x < 0.0f) {
            aABB.lowerBound.x += this.d.x;
        } else {
            aABB.upperBound.x += this.d.x;
        }
        if (this.d.y < 0.0f) {
            aABB.lowerBound.y += this.d.y;
        } else {
            aABB.upperBound.y += this.d.y;
        }
        dynamicTreeNode.aabb.set(aABB);
        this.insertLeaf(dynamicTreeNode);
        return true;
    }

    public final void rebalance(int n) {
        if (this.m_root == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            DynamicTreeNode dynamicTreeNode = this.m_root;
            int n2 = 0;
            while (!dynamicTreeNode.isLeaf()) {
                int n3 = this.m_path >> n2 & 1;
                dynamicTreeNode = n3 == 0 ? dynamicTreeNode.child1 : dynamicTreeNode.child2;
                n2 = n2 + 1 & 0x1F;
            }
            ++this.m_path;
            this.removeLeaf(dynamicTreeNode);
            this.insertLeaf(dynamicTreeNode);
        }
    }

    public final void query(TreeCallback treeCallback, AABB aABB) {
        this.query(treeCallback, aABB, this.m_root, 1);
    }

    private final boolean query(TreeCallback treeCallback, AABB aABB, DynamicTreeNode dynamicTreeNode, int n) {
        if (dynamicTreeNode == null) {
            return true;
        }
        if (AABB.testOverlap(aABB, dynamicTreeNode.aabb)) {
            if (dynamicTreeNode.isLeaf()) {
                boolean bl = treeCallback.treeCallback(dynamicTreeNode);
                if (!bl) {
                    return false;
                }
            } else {
                boolean bl;
                if (n < 128 && !(bl = this.query(treeCallback, aABB, dynamicTreeNode.child1, ++n))) {
                    return false;
                }
                if (n < 128 && !(bl = this.query(treeCallback, aABB, dynamicTreeNode.child2, ++n))) {
                    return false;
                }
            }
        }
        return true;
    }

    public void raycast(TreeRayCastCallback treeRayCastCallback, RayCastInput rayCastInput) {
        Vec2 vec2 = this.vec2s.pop();
        Vec2 vec22 = this.vec2s.pop();
        Vec2 vec23 = this.vec2s.pop();
        Vec2 vec24 = rayCastInput.p1;
        Vec2 vec25 = rayCastInput.p2;
        vec2.set(vec25).subLocal(vec24);
        assert (vec2.lengthSquared() > 0.0f);
        vec2.normalize();
        Vec2.crossToOut(1.0f, vec2, vec22);
        vec23.set(vec22).absLocal();
        float[] fArray = new float[]{rayCastInput.maxFraction};
        AABB aABB = this.aabb;
        Vec2 vec26 = this.vec2s.pop();
        vec26.set(vec25).subLocal(vec24).mulLocal(fArray[0]).addLocal(vec24);
        Vec2.minToOut(vec24, vec26, aABB.lowerBound);
        Vec2.maxToOut(vec24, vec26, aABB.upperBound);
        this.raycast(this.m_root, rayCastInput, 0, aABB, vec22, vec24, vec25, vec23, fArray, treeRayCastCallback);
        this.vec2s.push(4);
    }

    public boolean raycast(DynamicTreeNode dynamicTreeNode, RayCastInput rayCastInput, int n, AABB aABB, Vec2 vec2, Vec2 vec22, Vec2 vec23, Vec2 vec24, float[] fArray, TreeRayCastCallback treeRayCastCallback) {
        if (dynamicTreeNode == null) {
            return false;
        }
        if (!AABB.testOverlap(dynamicTreeNode.aabb, aABB)) {
            return false;
        }
        Vec2 vec25 = this.vec2s.pop();
        Vec2 vec26 = this.vec2s.pop();
        Vec2 vec27 = this.vec2s.pop();
        dynamicTreeNode.aabb.getCenterToOut(vec26);
        dynamicTreeNode.aabb.getExtentsToOut(vec27);
        vec25.set(vec22).subLocal(vec26);
        float f = MathUtils.abs(Vec2.dot(vec2, vec25)) - Vec2.dot(vec24, vec27);
        if (f > 0.0f) {
            this.vec2s.push(3);
            return false;
        }
        if (dynamicTreeNode.isLeaf()) {
            this.subInput.p1.set(rayCastInput.p1);
            this.subInput.p2.set(rayCastInput.p2);
            this.subInput.maxFraction = fArray[0];
            float f2 = treeRayCastCallback.raycastCallback(this.subInput, dynamicTreeNode);
            if (f2 == 0.0f) {
                this.vec2s.push(3);
                return true;
            }
            if (f2 > 0.0f) {
                fArray[0] = f2;
                vec25.set(vec23).subLocal(vec22).mulLocal(f2).addLocal(vec22);
                Vec2.minToOut(vec22, vec25, aABB.lowerBound);
                Vec2.maxToOut(vec22, vec25, aABB.upperBound);
            }
        } else {
            if (n < 128 && this.raycast(dynamicTreeNode.child1, rayCastInput, ++n, aABB, vec2, vec22, vec23, vec24, fArray, treeRayCastCallback)) {
                this.vec2s.push(3);
                return true;
            }
            if (n < 128 && this.raycast(dynamicTreeNode.child2, rayCastInput, ++n, aABB, vec2, vec22, vec23, vec24, fArray, treeRayCastCallback)) {
                this.vec2s.push(3);
                return true;
            }
        }
        this.vec2s.push(3);
        return false;
    }

    public final int computeHeight() {
        return this.computeHeight(this.m_root);
    }

    private final int computeHeight(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == null) {
            return 0;
        }
        assert (dynamicTreeNode != null);
        int n = this.computeHeight(dynamicTreeNode.child1);
        int n2 = this.computeHeight(dynamicTreeNode.child2);
        return 1 + MathUtils.max(n, n2);
    }

    private final DynamicTreeNode allocateNode() {
        if (this.nodeStack.isEmpty()) {
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
            this.nodeStack.push(new DynamicTreeNode());
        }
        DynamicTreeNode dynamicTreeNode = this.nodeStack.pop();
        dynamicTreeNode.parent = null;
        dynamicTreeNode.child1 = null;
        dynamicTreeNode.child2 = null;
        dynamicTreeNode.userData = null;
        dynamicTreeNode.key = this.nodeCounter++;
        ++this.m_nodeCount;
        return dynamicTreeNode;
    }

    private final void freeNode(DynamicTreeNode dynamicTreeNode) {
        assert (dynamicTreeNode != null);
        assert (0 < this.m_nodeCount);
        this.nodeStack.push(dynamicTreeNode);
        --this.m_nodeCount;
    }

    private final void insertLeaf(DynamicTreeNode dynamicTreeNode) {
        ++this.m_insertionCount;
        if (this.m_root == null) {
            this.m_root = dynamicTreeNode;
            dynamicTreeNode.parent = null;
            return;
        }
        dynamicTreeNode.aabb.getCenterToOut(this.center);
        DynamicTreeNode dynamicTreeNode2 = this.m_root;
        if (!dynamicTreeNode2.isLeaf()) {
            DynamicTreeNode dynamicTreeNode3;
            DynamicTreeNode dynamicTreeNode4;
            float f;
            float f2;
            do {
                dynamicTreeNode4 = dynamicTreeNode2.child1;
                dynamicTreeNode3 = dynamicTreeNode2.child2;
                dynamicTreeNode4.aabb.getCenterToOut(this.delta1);
                dynamicTreeNode3.aabb.getCenterToOut(this.delta2);
                this.delta1.subLocal(this.center).absLocal();
                this.delta2.subLocal(this.center).absLocal();
            } while (!(dynamicTreeNode2 = (f2 = this.delta1.x + this.delta1.y) < (f = this.delta2.x + this.delta2.y) ? dynamicTreeNode4 : dynamicTreeNode3).isLeaf());
        }
        DynamicTreeNode dynamicTreeNode5 = dynamicTreeNode2.parent;
        DynamicTreeNode dynamicTreeNode6 = this.allocateNode();
        dynamicTreeNode6.parent = dynamicTreeNode5;
        dynamicTreeNode6.userData = null;
        dynamicTreeNode6.aabb.combine(dynamicTreeNode.aabb, dynamicTreeNode2.aabb);
        if (dynamicTreeNode5 != null) {
            if (dynamicTreeNode2.parent.child1 == dynamicTreeNode2) {
                dynamicTreeNode5.child1 = dynamicTreeNode6;
            } else {
                dynamicTreeNode5.child2 = dynamicTreeNode6;
            }
            dynamicTreeNode6.child1 = dynamicTreeNode2;
            dynamicTreeNode6.child2 = dynamicTreeNode;
            dynamicTreeNode2.parent = dynamicTreeNode6;
            dynamicTreeNode.parent = dynamicTreeNode6;
            while (!dynamicTreeNode5.aabb.contains(dynamicTreeNode6.aabb)) {
                dynamicTreeNode5.aabb.combine(dynamicTreeNode5.child1.aabb, dynamicTreeNode5.child2.aabb);
                dynamicTreeNode6 = dynamicTreeNode5;
                dynamicTreeNode5 = dynamicTreeNode5.parent;
                if (dynamicTreeNode5 != null) continue;
                break;
            }
        } else {
            dynamicTreeNode6.child1 = dynamicTreeNode2;
            dynamicTreeNode6.child2 = dynamicTreeNode;
            dynamicTreeNode2.parent = dynamicTreeNode6;
            dynamicTreeNode.parent = dynamicTreeNode6;
            this.m_root = dynamicTreeNode6;
        }
    }

    private final void removeLeaf(DynamicTreeNode dynamicTreeNode) {
        if (dynamicTreeNode == this.m_root) {
            this.m_root = null;
            if (this.lastLeaf == dynamicTreeNode) {
                this.lastLeaf = null;
            }
            return;
        }
        DynamicTreeNode dynamicTreeNode2 = dynamicTreeNode.parent;
        DynamicTreeNode dynamicTreeNode3 = dynamicTreeNode2.parent;
        DynamicTreeNode dynamicTreeNode4 = dynamicTreeNode2.child1 == dynamicTreeNode ? dynamicTreeNode2.child2 : dynamicTreeNode2.child1;
        if (dynamicTreeNode3 != null) {
            if (dynamicTreeNode3.child1 == dynamicTreeNode2) {
                dynamicTreeNode3.child1 = dynamicTreeNode4;
            } else {
                dynamicTreeNode3.child2 = dynamicTreeNode4;
            }
            dynamicTreeNode4.parent = dynamicTreeNode3;
            this.freeNode(dynamicTreeNode2);
            while (dynamicTreeNode3 != null) {
                this.oldAABB.set(dynamicTreeNode3.aabb);
                dynamicTreeNode3.aabb.combine(dynamicTreeNode3.child1.aabb, dynamicTreeNode3.child2.aabb);
                if (!this.oldAABB.contains(dynamicTreeNode3.aabb)) {
                    dynamicTreeNode3 = dynamicTreeNode3.parent;
                    continue;
                }
                break;
            }
        } else {
            this.m_root = dynamicTreeNode4;
            dynamicTreeNode4.parent = null;
            this.freeNode(dynamicTreeNode2);
        }
        if (this.lastLeaf == dynamicTreeNode) {
            this.lastLeaf = this.m_root;
        }
    }

    public void drawTree(DebugDraw debugDraw) {
        if (this.m_root == null) {
            return;
        }
        int n = this.computeHeight();
        this.drawTree(debugDraw, this.m_root, 0, n);
    }

    public void drawTree(DebugDraw debugDraw, DynamicTreeNode dynamicTreeNode, int n, int n2) {
        dynamicTreeNode.aabb.getVertices(this.drawVecs);
        this.color.set(1.0f, (float)(n2 - n) * 1.0f / (float)n2, (float)(n2 - n) * 1.0f / (float)n2);
        debugDraw.drawPolygon(this.drawVecs, 4, this.color);
        debugDraw.getViewportTranform().getWorldToScreen(dynamicTreeNode.aabb.upperBound, this.textVec);
        debugDraw.drawString(this.textVec.x, this.textVec.y, n + 1 + "/" + n2, this.color);
        if (dynamicTreeNode.child1 != null) {
            this.drawTree(debugDraw, dynamicTreeNode.child1, n + 1, n2);
        }
        if (dynamicTreeNode.child2 != null) {
            this.drawTree(debugDraw, dynamicTreeNode.child2, n + 1, n2);
        }
    }
}

