/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import java.io.Serializable;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;

public class Transform
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final Vec2 position;
    public final Mat22 R;

    public Transform() {
        this.position = new Vec2();
        this.R = new Mat22();
    }

    public Transform(Transform transform) {
        this.position = transform.position.clone();
        this.R = transform.R.clone();
    }

    public Transform(Vec2 vec2, Mat22 mat22) {
        this.position = vec2.clone();
        this.R = mat22.clone();
    }

    public final Transform set(Transform transform) {
        this.position.set(transform.position);
        this.R.set(transform.R);
        return this;
    }

    public final void set(Vec2 vec2, float f) {
        this.position.set(vec2);
        this.R.set(f);
    }

    public final float getAngle() {
        return MathUtils.atan2(this.R.col1.y, this.R.col1.x);
    }

    public final void setIdentity() {
        this.position.setZero();
        this.R.setIdentity();
    }

    public static final Vec2 mul(Transform transform, Vec2 vec2) {
        return new Vec2(transform.position.x + transform.R.col1.x * vec2.x + transform.R.col2.x * vec2.y, transform.position.y + transform.R.col1.y * vec2.x + transform.R.col2.y * vec2.y);
    }

    public static final void mulToOut(Transform transform, Vec2 vec2, Vec2 vec22) {
        float f = transform.position.y + transform.R.col1.y * vec2.x + transform.R.col2.y * vec2.y;
        vec22.x = transform.position.x + transform.R.col1.x * vec2.x + transform.R.col2.x * vec2.y;
        vec22.y = f;
    }

    public static final Vec2 mulTrans(Transform transform, Vec2 vec2) {
        float f = vec2.x - transform.position.x;
        float f2 = vec2.y - transform.position.y;
        Vec2 vec22 = transform.R.col1;
        Vec2 vec23 = transform.R.col2;
        return new Vec2(f * vec22.x + f2 * vec22.y, f * vec23.x + f2 * vec23.y);
    }

    public static final void mulTransToOut(Transform transform, Vec2 vec2, Vec2 vec22) {
        float f = vec2.x - transform.position.x;
        float f2 = vec2.y - transform.position.y;
        Vec2 vec23 = transform.R.col1;
        Vec2 vec24 = transform.R.col2;
        float f3 = f * vec24.x + f2 * vec24.y;
        vec22.x = f * vec23.x + f2 * vec23.y;
        vec22.y = f3;
    }

    public final String toString() {
        String string = "XForm:\n";
        string = string + "Position: " + this.position + "\n";
        string = string + "R: \n" + this.R + "\n";
        return string;
    }
}

