/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Transform;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.ContactEdge;
import org.jbox2d.pooling.IWorldPool;
import org.jbox2d.pooling.TLManifold;

public abstract class Contact {
    public static final int ISLAND_FLAG = 1;
    public static final int TOUCHING_FLAG = 2;
    public static final int ENABLED_FLAG = 4;
    public static final int FILTER_FLAG = 8;
    public static final int BULLET_HIT_FLAG = 16;
    public int m_flags;
    public Contact m_prev;
    public Contact m_next;
    public ContactEdge m_nodeA = new ContactEdge();
    public ContactEdge m_nodeB = new ContactEdge();
    public Fixture m_fixtureA = null;
    public Fixture m_fixtureB = null;
    public Manifold m_manifold = new Manifold();
    public float m_toiCount;
    protected final IWorldPool pool;
    private static final TLManifold tloldManifold = new TLManifold();

    protected Contact(IWorldPool iWorldPool) {
        this.pool = iWorldPool;
    }

    public void init(Fixture fixture, Fixture fixture2) {
        this.m_flags = 0;
        this.m_fixtureA = fixture;
        this.m_fixtureB = fixture2;
        this.m_manifold.pointCount = 0;
        this.m_prev = null;
        this.m_next = null;
        this.m_nodeA.contact = null;
        this.m_nodeA.prev = null;
        this.m_nodeA.next = null;
        this.m_nodeA.other = null;
        this.m_nodeB.contact = null;
        this.m_nodeB.prev = null;
        this.m_nodeB.next = null;
        this.m_nodeB.other = null;
        this.m_toiCount = 0.0f;
    }

    public Manifold getManifold() {
        return this.m_manifold;
    }

    public void getWorldManifold(WorldManifold worldManifold) {
        Body body = this.m_fixtureA.getBody();
        Body body2 = this.m_fixtureB.getBody();
        Shape shape = this.m_fixtureA.getShape();
        Shape shape2 = this.m_fixtureB.getShape();
        worldManifold.initialize(this.m_manifold, body.getTransform(), shape.m_radius, body2.getTransform(), shape2.m_radius);
    }

    public boolean isTouching() {
        return (this.m_flags & 2) == 2;
    }

    public void setEnabled(boolean bl) {
        this.m_flags = bl ? (this.m_flags |= 4) : (this.m_flags &= 0xFFFFFFFB);
    }

    public boolean isEnabled() {
        return (this.m_flags & 4) == 4;
    }

    public Contact getNext() {
        return this.m_next;
    }

    public Fixture getFixtureA() {
        return this.m_fixtureA;
    }

    public Fixture getFixtureB() {
        return this.m_fixtureB;
    }

    public abstract void evaluate(Manifold var1, Transform var2, Transform var3);

    public void flagForFiltering() {
        this.m_flags |= 8;
    }

    public void update(ContactListener contactListener) {
        Manifold manifold = (Manifold)tloldManifold.get();
        manifold.set(this.m_manifold);
        this.m_flags |= 4;
        boolean bl = false;
        boolean bl2 = (this.m_flags & 2) == 2;
        boolean bl3 = this.m_fixtureA.isSensor();
        boolean bl4 = this.m_fixtureB.isSensor();
        boolean bl5 = bl3 || bl4;
        Body body = this.m_fixtureA.getBody();
        Body body2 = this.m_fixtureB.getBody();
        Transform transform = body.getTransform();
        Transform transform2 = body2.getTransform();
        if (bl5) {
            Shape shape = this.m_fixtureA.getShape();
            Shape shape2 = this.m_fixtureB.getShape();
            bl = this.pool.getCollision().testOverlap(shape, shape2, transform, transform2);
            this.m_manifold.pointCount = 0;
        } else {
            this.evaluate(this.m_manifold, transform, transform2);
            bl = this.m_manifold.pointCount > 0;
            block0: for (int i = 0; i < this.m_manifold.pointCount; ++i) {
                ManifoldPoint manifoldPoint = this.m_manifold.points[i];
                manifoldPoint.normalImpulse = 0.0f;
                manifoldPoint.tangentImpulse = 0.0f;
                ContactID contactID = manifoldPoint.id;
                for (int j = 0; j < manifold.pointCount; ++j) {
                    ManifoldPoint manifoldPoint2 = manifold.points[j];
                    if (!manifoldPoint2.id.isEqual(contactID)) continue;
                    manifoldPoint.normalImpulse = manifoldPoint2.normalImpulse;
                    manifoldPoint.tangentImpulse = manifoldPoint2.tangentImpulse;
                    continue block0;
                }
            }
            if (bl != bl2) {
                body.setAwake(true);
                body2.setAwake(true);
            }
        }
        this.m_flags = bl ? (this.m_flags |= 2) : (this.m_flags &= 0xFFFFFFFD);
        if (contactListener == null) {
            return;
        }
        if (!bl2 && bl) {
            contactListener.beginContact(this);
        }
        if (bl2 && !bl) {
            contactListener.endContact(this);
        }
        if (!bl5 && bl) {
            contactListener.preSolve(this, manifold);
        }
    }
}

