/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactConstraint;
import org.jbox2d.dynamics.contacts.ContactConstraintPoint;
import org.jbox2d.dynamics.contacts.PositionSolverManifold;

public class ContactSolver {
    public static final int INITIAL_NUM_CONSTRAINTS = 256;
    public static final float k_maxConditionNumber = 100.0f;
    public ContactConstraint[] m_constraints;
    public int m_constraintCount;
    private final WorldManifold worldManifold = new WorldManifold();
    private final Vec2 tangent = new Vec2();
    private final Vec2 temp1 = new Vec2();
    private final Vec2 temp2 = new Vec2();
    private final Vec2 P = new Vec2();
    private final Vec2 dv = new Vec2();
    private final Vec2 a = new Vec2();
    private final Vec2 b = new Vec2();
    private final Vec2 dv1 = new Vec2();
    private final Vec2 dv2 = new Vec2();
    private final Vec2 x = new Vec2();
    private final Vec2 d = new Vec2();
    private final Vec2 P1 = new Vec2();
    private final Vec2 P2 = new Vec2();
    private final PositionSolverManifold psolver = new PositionSolverManifold();
    private final Vec2 rA = new Vec2();
    private final Vec2 rB = new Vec2();

    public ContactSolver() {
        this.m_constraints = new ContactConstraint[256];
        for (int i = 0; i < this.m_constraints.length; ++i) {
            this.m_constraints[i] = new ContactConstraint();
        }
    }

    public final void init(Contact[] contactArray, int n, float f) {
        this.m_constraintCount = n;
        if (this.m_constraints.length <= n) {
            ContactConstraint[] contactConstraintArray = new ContactConstraint[this.m_constraintCount * 2];
            for (int i = 0; i < contactConstraintArray.length; ++i) {
                contactConstraintArray[i] = i < this.m_constraints.length ? this.m_constraints[i] : new ContactConstraint();
            }
            this.m_constraints = contactConstraintArray;
        }
        for (int i = 0; i < this.m_constraintCount; ++i) {
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            float f7;
            float f8;
            float f9;
            float f10;
            float f11;
            Object object;
            Contact contact = contactArray[i];
            Fixture fixture = contact.m_fixtureA;
            Fixture fixture2 = contact.m_fixtureB;
            Shape shape = fixture.getShape();
            Shape shape2 = fixture2.getShape();
            float f12 = shape.m_radius;
            float f13 = shape2.m_radius;
            Body body = fixture.getBody();
            Body body2 = fixture2.getBody();
            Manifold manifold = contact.getManifold();
            float f14 = Settings.mixFriction(fixture.getFriction(), fixture2.getFriction());
            float f15 = Settings.mixRestitution(fixture.getRestitution(), fixture2.getRestitution());
            Vec2 vec2 = body.m_linearVelocity;
            Vec2 vec22 = body2.m_linearVelocity;
            float f16 = body.m_angularVelocity;
            float f17 = body2.m_angularVelocity;
            assert (manifold.pointCount > 0);
            this.worldManifold.initialize(manifold, body.m_xf, f12, body2.m_xf, f13);
            ContactConstraint contactConstraint = this.m_constraints[i];
            contactConstraint.bodyA = body;
            contactConstraint.bodyB = body2;
            contactConstraint.manifold = manifold;
            contactConstraint.normal.x = this.worldManifold.normal.x;
            contactConstraint.normal.y = this.worldManifold.normal.y;
            contactConstraint.pointCount = manifold.pointCount;
            contactConstraint.friction = f14;
            contactConstraint.restitution = f15;
            contactConstraint.localNormal.x = manifold.localNormal.x;
            contactConstraint.localNormal.y = manifold.localNormal.y;
            contactConstraint.localPoint.x = manifold.localPoint.x;
            contactConstraint.localPoint.y = manifold.localPoint.y;
            contactConstraint.radius = f12 + f13;
            contactConstraint.type = manifold.type;
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                object = manifold.points[j];
                ContactConstraintPoint contactConstraintPoint = contactConstraint.points[j];
                contactConstraintPoint.normalImpulse = f * ((ManifoldPoint)object).normalImpulse;
                contactConstraintPoint.tangentImpulse = f * ((ManifoldPoint)object).tangentImpulse;
                contactConstraintPoint.localPoint.x = ((ManifoldPoint)object).localPoint.x;
                contactConstraintPoint.localPoint.y = ((ManifoldPoint)object).localPoint.y;
                contactConstraintPoint.rA.x = this.worldManifold.points[j].x - body.m_sweep.c.x;
                contactConstraintPoint.rA.y = this.worldManifold.points[j].y - body.m_sweep.c.y;
                contactConstraintPoint.rB.x = this.worldManifold.points[j].x - body2.m_sweep.c.x;
                contactConstraintPoint.rB.y = this.worldManifold.points[j].y - body2.m_sweep.c.y;
                f11 = contactConstraintPoint.rA.x * contactConstraint.normal.y - contactConstraintPoint.rA.y * contactConstraint.normal.x;
                f10 = contactConstraintPoint.rB.x * contactConstraint.normal.y - contactConstraintPoint.rB.y * contactConstraint.normal.x;
                f11 *= f11;
                f10 *= f10;
                f9 = body.m_invMass + body2.m_invMass + body.m_invI * f11 + body2.m_invI * f10;
                assert (f9 > 1.1920929E-7f);
                contactConstraintPoint.normalMass = 1.0f / f9;
                this.tangent.x = 1.0f * contactConstraint.normal.y;
                this.tangent.y = -1.0f * contactConstraint.normal.x;
                f8 = contactConstraintPoint.rA.x * this.tangent.y - contactConstraintPoint.rA.y * this.tangent.x;
                f7 = contactConstraintPoint.rB.x * this.tangent.y - contactConstraintPoint.rB.y * this.tangent.x;
                f8 *= f8;
                f7 *= f7;
                f6 = body.m_invMass + body2.m_invMass + body.m_invI * f8 + body2.m_invI * f7;
                assert (f6 > 1.1920929E-7f);
                contactConstraintPoint.tangentMass = 1.0f / f6;
                contactConstraintPoint.velocityBias = 0.0f;
                this.temp2.x = -f16 * contactConstraintPoint.rA.y;
                this.temp2.y = f16 * contactConstraintPoint.rA.x;
                this.temp1.x = -f17 * contactConstraintPoint.rB.y + vec22.x - vec2.x - this.temp2.x;
                this.temp1.y = f17 * contactConstraintPoint.rB.x + vec22.y - vec2.y - this.temp2.y;
                Vec2 vec23 = contactConstraint.normal;
                f5 = vec23.x * this.temp1.x + vec23.y * this.temp1.y;
                if (!(f5 < -Settings.velocityThreshold)) continue;
                contactConstraintPoint.velocityBias = -f15 * f5;
            }
            if (contactConstraint.pointCount != 2) continue;
            ContactConstraintPoint contactConstraintPoint = contactConstraint.points[0];
            object = contactConstraint.points[1];
            float f18 = body.m_invMass;
            f11 = body.m_invI;
            f10 = body2.m_invMass;
            f9 = body2.m_invI;
            f8 = Vec2.cross(contactConstraintPoint.rA, contactConstraint.normal);
            f5 = f18 + f10 + f11 * f8 * f8 + f9 * (f7 = Vec2.cross(contactConstraintPoint.rB, contactConstraint.normal)) * f7;
            if (f5 * f5 < 100.0f * (f5 * (f4 = f18 + f10 + f11 * (f6 = Vec2.cross(((ContactConstraintPoint)object).rA, contactConstraint.normal)) * f6 + f9 * (f3 = Vec2.cross(((ContactConstraintPoint)object).rB, contactConstraint.normal)) * f3) - (f2 = f18 + f10 + f11 * f8 * f6 + f9 * f7 * f3) * f2)) {
                contactConstraint.K.col1.x = f5;
                contactConstraint.K.col1.y = f2;
                contactConstraint.K.col2.x = f2;
                contactConstraint.K.col2.y = f4;
                contactConstraint.normalMass.col1.x = contactConstraint.K.col1.x;
                contactConstraint.normalMass.col1.y = contactConstraint.K.col1.y;
                contactConstraint.normalMass.col2.x = contactConstraint.K.col2.x;
                contactConstraint.normalMass.col2.y = contactConstraint.K.col2.y;
                contactConstraint.normalMass.invertLocal();
                continue;
            }
            contactConstraint.pointCount = 1;
        }
    }

    public void warmStart() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint contactConstraint = this.m_constraints[i];
            Body body = contactConstraint.bodyA;
            Body body2 = contactConstraint.bodyB;
            float f = body.m_invMass;
            float f2 = body.m_invI;
            float f3 = body2.m_invMass;
            float f4 = body2.m_invI;
            Vec2 vec2 = contactConstraint.normal;
            Vec2.crossToOut(vec2, 1.0f, this.tangent);
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                ContactConstraintPoint contactConstraintPoint = contactConstraint.points[j];
                float f5 = contactConstraintPoint.normalImpulse * vec2.x + contactConstraintPoint.tangentImpulse * this.tangent.x;
                float f6 = contactConstraintPoint.normalImpulse * vec2.y + contactConstraintPoint.tangentImpulse * this.tangent.y;
                body.m_angularVelocity -= f2 * (contactConstraintPoint.rA.x * f6 - contactConstraintPoint.rA.y * f5);
                body.m_linearVelocity.x -= f5 * f;
                body.m_linearVelocity.y -= f6 * f;
                body2.m_angularVelocity += f4 * (contactConstraintPoint.rB.x * f6 - contactConstraintPoint.rB.y * f5);
                body2.m_linearVelocity.x += f5 * f3;
                body2.m_linearVelocity.y += f6 * f3;
            }
        }
    }

    public final void solveVelocityConstraints() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraintPoint contactConstraintPoint;
            float f;
            float f2;
            float f3;
            float f4;
            float f5;
            float f6;
            Vec2 vec2;
            Object object;
            ContactConstraint contactConstraint = this.m_constraints[i];
            Body body = contactConstraint.bodyA;
            Body body2 = contactConstraint.bodyB;
            float f7 = body.m_angularVelocity;
            float f8 = body2.m_angularVelocity;
            Vec2 vec22 = body.m_linearVelocity;
            Vec2 vec23 = body2.m_linearVelocity;
            float f9 = body.m_invMass;
            float f10 = body.m_invI;
            float f11 = body2.m_invMass;
            float f12 = body2.m_invI;
            this.tangent.x = 1.0f * contactConstraint.normal.y;
            this.tangent.y = -1.0f * contactConstraint.normal.x;
            float f13 = contactConstraint.friction;
            assert (contactConstraint.pointCount == 1 || contactConstraint.pointCount == 2);
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                object = contactConstraint.points[j];
                vec2 = ((ContactConstraintPoint)object).rA;
                this.dv.x = -f8 * ((ContactConstraintPoint)object).rB.y + vec23.x - vec22.x + f7 * vec2.y;
                this.dv.y = f8 * ((ContactConstraintPoint)object).rB.x + vec23.y - vec22.y - f7 * vec2.x;
                f6 = this.dv.x * this.tangent.x + this.dv.y * this.tangent.y;
                f5 = ((ContactConstraintPoint)object).tangentMass * -f6;
                f4 = f13 * ((ContactConstraintPoint)object).normalImpulse;
                f3 = MathUtils.clamp(((ContactConstraintPoint)object).tangentImpulse + f5, -f4, f4);
                f5 = f3 - ((ContactConstraintPoint)object).tangentImpulse;
                f2 = this.tangent.x * f5;
                f = this.tangent.y * f5;
                vec22.x -= f2 * f9;
                vec22.y -= f * f9;
                f7 -= f10 * (((ContactConstraintPoint)object).rA.x * f - ((ContactConstraintPoint)object).rA.y * f2);
                vec23.x += f2 * f11;
                vec23.y += f * f11;
                f8 += f12 * (((ContactConstraintPoint)object).rB.x * f - ((ContactConstraintPoint)object).rB.y * f2);
                ((ContactConstraintPoint)object).tangentImpulse = f3;
            }
            if (contactConstraint.pointCount == 1) {
                contactConstraintPoint = contactConstraint.points[0];
                object = contactConstraintPoint.rA;
                this.dv.x = -f8 * contactConstraintPoint.rB.y + vec23.x - vec22.x + f7 * ((Vec2)object).y;
                this.dv.y = f8 * contactConstraintPoint.rB.x + vec23.y - vec22.y - f7 * ((Vec2)object).x;
                vec2 = contactConstraint.normal;
                f6 = this.dv.x * vec2.x + this.dv.y * vec2.y;
                f5 = -contactConstraintPoint.normalMass * (f6 - contactConstraintPoint.velocityBias);
                f4 = contactConstraintPoint.normalImpulse + f5;
                f3 = f4 > 0.0f ? f4 : 0.0f;
                f5 = f3 - contactConstraintPoint.normalImpulse;
                f2 = contactConstraint.normal.x * f5;
                f = contactConstraint.normal.y * f5;
                vec22.x -= f2 * f9;
                vec22.y -= f * f9;
                f7 -= f10 * (contactConstraintPoint.rA.x * f - contactConstraintPoint.rA.y * f2);
                vec23.x += f2 * f11;
                vec23.y += f * f11;
                f8 += f12 * (contactConstraintPoint.rB.x * f - contactConstraintPoint.rB.y * f2);
                contactConstraintPoint.normalImpulse = f3;
            } else {
                contactConstraintPoint = contactConstraint.points[0];
                object = contactConstraint.points[1];
                this.a.x = contactConstraintPoint.normalImpulse;
                this.a.y = ((ContactConstraintPoint)object).normalImpulse;
                assert (this.a.x >= 0.0f && this.a.y >= 0.0f);
                this.dv1.x = -f8 * contactConstraintPoint.rB.y + vec23.x - vec22.x + f7 * contactConstraintPoint.rA.y;
                this.dv1.y = f8 * contactConstraintPoint.rB.x + vec23.y - vec22.y - f7 * contactConstraintPoint.rA.x;
                this.dv2.x = -f8 * ((ContactConstraintPoint)object).rB.y + vec23.x - vec22.x + f7 * ((ContactConstraintPoint)object).rA.y;
                this.dv2.y = f8 * ((ContactConstraintPoint)object).rB.x + vec23.y - vec22.y - f7 * ((ContactConstraintPoint)object).rA.x;
                float f14 = this.dv1.x * contactConstraint.normal.x + this.dv1.y * contactConstraint.normal.y;
                f6 = this.dv2.x * contactConstraint.normal.x + this.dv2.y * contactConstraint.normal.y;
                this.b.x = f14 - contactConstraintPoint.velocityBias;
                this.b.y = f6 - ((ContactConstraintPoint)object).velocityBias;
                this.temp2.x = contactConstraint.K.col1.x * this.a.x + contactConstraint.K.col2.x * this.a.y;
                this.temp2.y = contactConstraint.K.col1.y * this.a.x + contactConstraint.K.col2.y * this.a.y;
                this.b.x -= this.temp2.x;
                this.b.y -= this.temp2.y;
                Mat22.mulToOut(contactConstraint.normalMass, this.b, this.x);
                this.x.mulLocal(-1.0f);
                if (this.x.x >= 0.0f && this.x.y >= 0.0f) {
                    this.d.set(this.x).subLocal(this.a);
                    this.P1.set(contactConstraint.normal).mulLocal(this.d.x);
                    this.P2.set(contactConstraint.normal).mulLocal(this.d.y);
                    this.temp1.set(this.P1).addLocal(this.P2);
                    this.temp2.set(this.temp1).mulLocal(f9);
                    vec22.subLocal(this.temp2);
                    this.temp2.set(this.temp1).mulLocal(f11);
                    vec23.addLocal(this.temp2);
                    f7 -= f10 * (Vec2.cross(contactConstraintPoint.rA, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rA, this.P2));
                    f8 += f12 * (Vec2.cross(contactConstraintPoint.rB, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rB, this.P2));
                    contactConstraintPoint.normalImpulse = this.x.x;
                    ((ContactConstraintPoint)object).normalImpulse = this.x.y;
                } else {
                    this.x.x = -contactConstraintPoint.normalMass * this.b.x;
                    this.x.y = 0.0f;
                    f14 = 0.0f;
                    f6 = contactConstraint.K.col1.y * this.x.x + this.b.y;
                    if (this.x.x >= 0.0f && f6 >= 0.0f) {
                        this.d.set(this.x).subLocal(this.a);
                        this.P1.set(contactConstraint.normal).mulLocal(this.d.x);
                        this.P2.set(contactConstraint.normal).mulLocal(this.d.y);
                        this.temp1.set(this.P1).addLocal(this.P2);
                        this.temp2.set(this.temp1).mulLocal(f9);
                        vec22.subLocal(this.temp2);
                        this.temp2.set(this.temp1).mulLocal(f11);
                        vec23.addLocal(this.temp2);
                        f7 -= f10 * (Vec2.cross(contactConstraintPoint.rA, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rA, this.P2));
                        f8 += f12 * (Vec2.cross(contactConstraintPoint.rB, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rB, this.P2));
                        contactConstraintPoint.normalImpulse = this.x.x;
                        ((ContactConstraintPoint)object).normalImpulse = this.x.y;
                    } else {
                        this.x.x = 0.0f;
                        this.x.y = -((ContactConstraintPoint)object).normalMass * this.b.y;
                        f14 = contactConstraint.K.col2.x * this.x.y + this.b.x;
                        f6 = 0.0f;
                        if (this.x.y >= 0.0f && f14 >= 0.0f) {
                            this.d.set(this.x).subLocal(this.a);
                            this.P1.set(contactConstraint.normal).mulLocal(this.d.x);
                            this.P2.set(contactConstraint.normal).mulLocal(this.d.y);
                            this.temp1.set(this.P1).addLocal(this.P2);
                            this.temp2.set(this.temp1).mulLocal(f9);
                            vec22.subLocal(this.temp2);
                            this.temp2.set(this.temp1).mulLocal(f11);
                            vec23.addLocal(this.temp2);
                            f7 -= f10 * (Vec2.cross(contactConstraintPoint.rA, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rA, this.P2));
                            f8 += f12 * (Vec2.cross(contactConstraintPoint.rB, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rB, this.P2));
                            contactConstraintPoint.normalImpulse = this.x.x;
                            ((ContactConstraintPoint)object).normalImpulse = this.x.y;
                        } else {
                            this.x.x = 0.0f;
                            this.x.y = 0.0f;
                            f14 = this.b.x;
                            f6 = this.b.y;
                            if (f14 >= 0.0f && f6 >= 0.0f) {
                                this.d.set(this.x).subLocal(this.a);
                                this.P1.set(contactConstraint.normal).mulLocal(this.d.x);
                                this.P2.set(contactConstraint.normal).mulLocal(this.d.y);
                                this.temp1.set(this.P1).addLocal(this.P2);
                                this.temp2.set(this.temp1).mulLocal(f9);
                                vec22.subLocal(this.temp2);
                                this.temp2.set(this.temp1).mulLocal(f11);
                                vec23.addLocal(this.temp2);
                                f7 -= f10 * (Vec2.cross(contactConstraintPoint.rA, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rA, this.P2));
                                f8 += f12 * (Vec2.cross(contactConstraintPoint.rB, this.P1) + Vec2.cross(((ContactConstraintPoint)object).rB, this.P2));
                                contactConstraintPoint.normalImpulse = this.x.x;
                                ((ContactConstraintPoint)object).normalImpulse = this.x.y;
                            }
                        }
                    }
                }
            }
            body.m_linearVelocity.set(vec22);
            body.m_angularVelocity = f7;
            body2.m_linearVelocity.set(vec23);
            body2.m_angularVelocity = f8;
        }
    }

    public void storeImpulses() {
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint contactConstraint = this.m_constraints[i];
            Manifold manifold = contactConstraint.manifold;
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                manifold.points[j].normalImpulse = contactConstraint.points[j].normalImpulse;
                manifold.points[j].tangentImpulse = contactConstraint.points[j].tangentImpulse;
            }
        }
    }

    public final boolean solvePositionConstraints(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < this.m_constraintCount; ++i) {
            ContactConstraint contactConstraint = this.m_constraints[i];
            Body body = contactConstraint.bodyA;
            Body body2 = contactConstraint.bodyB;
            float f3 = body.m_mass * body.m_invMass;
            float f4 = body.m_mass * body.m_invI;
            float f5 = body2.m_mass * body2.m_invMass;
            float f6 = body2.m_mass * body2.m_invI;
            for (int j = 0; j < contactConstraint.pointCount; ++j) {
                PositionSolverManifold positionSolverManifold = this.psolver;
                positionSolverManifold.initialize(contactConstraint, j);
                Vec2 vec2 = positionSolverManifold.normal;
                Vec2 vec22 = positionSolverManifold.point;
                float f7 = positionSolverManifold.separation;
                this.rA.set(vec22).subLocal(body.m_sweep.c);
                this.rB.set(vec22).subLocal(body2.m_sweep.c);
                f2 = MathUtils.min(f2, f7);
                float f8 = MathUtils.clamp(f * (f7 + Settings.linearSlop), -Settings.maxLinearCorrection, 0.0f);
                float f9 = Vec2.cross(this.rA, vec2);
                float f10 = Vec2.cross(this.rB, vec2);
                float f11 = f3 + f5 + f4 * f9 * f9 + f6 * f10 * f10;
                float f12 = f11 > 0.0f ? -f8 / f11 : 0.0f;
                this.P.set(vec2).mulLocal(f12);
                this.temp1.set(this.P).mulLocal(f3);
                body.m_sweep.c.subLocal(this.temp1);
                body.m_sweep.a -= f4 * Vec2.cross(this.rA, this.P);
                body.synchronizeTransform();
                this.temp1.set(this.P).mulLocal(f5);
                body2.m_sweep.c.addLocal(this.temp1);
                body2.m_sweep.a += f6 * Vec2.cross(this.rB, this.P);
                body2.synchronizeTransform();
            }
        }
        return f2 >= -1.5f * Settings.linearSlop;
    }
}

