/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.pooling.IWorldPool;

public class MouseJoint
extends Joint {
    private final Vec2 m_localAnchor = new Vec2();
    private final Vec2 m_target = new Vec2();
    private final Vec2 m_impulse = new Vec2();
    private final Mat22 m_mass = new Mat22();
    private final Vec2 m_C = new Vec2();
    private float m_maxForce;
    private float m_frequencyHz;
    private float m_dampingRatio;
    private float m_beta;
    private float m_gamma;

    protected MouseJoint(IWorldPool iWorldPool, MouseJointDef mouseJointDef) {
        super(iWorldPool, mouseJointDef);
        assert (mouseJointDef.target.isValid());
        assert (mouseJointDef.maxForce >= 0.0f);
        assert (mouseJointDef.frequencyHz >= 0.0f);
        assert (mouseJointDef.dampingRatio >= 0.0f);
        this.m_target.set(mouseJointDef.target);
        Transform.mulTransToOut(this.m_bodyB.getTransform(), this.m_target, this.m_localAnchor);
        this.m_maxForce = mouseJointDef.maxForce;
        this.m_impulse.setZero();
        this.m_frequencyHz = mouseJointDef.frequencyHz;
        this.m_dampingRatio = mouseJointDef.dampingRatio;
        this.m_beta = 0.0f;
        this.m_gamma = 0.0f;
    }

    public void getAnchorA(Vec2 vec2) {
        vec2.set(this.m_target);
    }

    public void getAnchorB(Vec2 vec2) {
        this.m_bodyB.getWorldPointToOut(this.m_localAnchor, vec2);
    }

    public void getReactionForce(float f, Vec2 vec2) {
        vec2.set(this.m_impulse).mulLocal(f);
    }

    public float getReactionTorque(float f) {
        return f * 0.0f;
    }

    public void setTarget(Vec2 vec2) {
        if (!this.m_bodyB.isAwake()) {
            this.m_bodyB.setAwake(true);
        }
        this.m_target.set(vec2);
    }

    public Vec2 getTarget() {
        return this.m_target;
    }

    public void setMaxForce(float f) {
        this.m_maxForce = f;
    }

    public float getMaxForce() {
        return this.m_maxForce;
    }

    public void setFrequency(float f) {
        this.m_frequencyHz = f;
    }

    public float getFrequency() {
        return this.m_frequencyHz;
    }

    public void setDampingRatio(float f) {
        this.m_dampingRatio = f;
    }

    public float getDampingRatio() {
        return this.m_dampingRatio;
    }

    public void initVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyB;
        float f = body.getMass();
        float f2 = (float)Math.PI * 2 * this.m_frequencyHz;
        float f3 = 2.0f * f * this.m_dampingRatio * f2;
        float f4 = f * (f2 * f2);
        assert (f3 + timeStep.dt * f4 > 1.1920929E-7f);
        this.m_gamma = timeStep.dt * (f3 + timeStep.dt * f4);
        if (this.m_gamma != 0.0f) {
            this.m_gamma = 1.0f / this.m_gamma;
        }
        this.m_beta = timeStep.dt * f4 * this.m_gamma;
        Vec2 vec2 = this.pool.popVec2();
        vec2.set(this.m_localAnchor).subLocal(body.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        float f5 = body.m_invMass;
        float f6 = body.m_invI;
        Mat22 mat22 = this.pool.popMat22();
        mat22.col1.x = f5;
        mat22.col2.x = 0.0f;
        mat22.col1.y = 0.0f;
        mat22.col2.y = f5;
        Mat22 mat222 = this.pool.popMat22();
        mat222.col1.x = f6 * vec2.y * vec2.y;
        mat222.col2.x = -f6 * vec2.x * vec2.y;
        mat222.col1.y = -f6 * vec2.x * vec2.y;
        mat222.col2.y = f6 * vec2.x * vec2.x;
        Mat22 mat223 = this.pool.popMat22();
        mat223.set(mat22).addLocal(mat222);
        mat223.col1.x += this.m_gamma;
        mat223.col2.y += this.m_gamma;
        mat223.invertToOut(this.m_mass);
        this.m_C.set(body.m_sweep.c).addLocal(vec2).subLocal(this.m_target);
        body.m_angularVelocity *= 0.98f;
        this.m_impulse.mulLocal(timeStep.dtRatio);
        Vec2 vec22 = this.pool.popVec2();
        vec22.set(this.m_impulse).mulLocal(f5);
        body.m_linearVelocity.addLocal(vec22);
        body.m_angularVelocity += f6 * Vec2.cross(vec2, this.m_impulse);
        this.pool.pushVec2(2);
        this.pool.pushMat22(3);
    }

    public boolean solvePositionConstraints(float f) {
        return true;
    }

    public void solveVelocityConstraints(TimeStep timeStep) {
        Body body = this.m_bodyB;
        Vec2 vec2 = this.pool.popVec2();
        vec2.set(this.m_localAnchor).subLocal(body.getLocalCenter());
        Mat22.mulToOut(body.getTransform().R, vec2, vec2);
        Vec2 vec22 = this.pool.popVec2();
        Vec2.crossToOut(body.m_angularVelocity, vec2, vec22);
        vec22.addLocal(body.m_linearVelocity);
        Vec2 vec23 = this.pool.popVec2();
        Vec2 vec24 = this.pool.popVec2();
        vec23.set(this.m_C).mulLocal(this.m_beta);
        vec24.set(this.m_impulse).mulLocal(this.m_gamma);
        vec24.addLocal(vec23).addLocal(vec22).mulLocal(-1.0f);
        Mat22.mulToOut(this.m_mass, vec24, vec23);
        Vec2 vec25 = vec24;
        vec25.set(this.m_impulse);
        this.m_impulse.addLocal(vec23);
        float f = timeStep.dt * this.m_maxForce;
        if (this.m_impulse.lengthSquared() > f * f) {
            this.m_impulse.mulLocal(f / this.m_impulse.length());
        }
        vec23.set(this.m_impulse).subLocal(vec25);
        vec25.set(vec23).mulLocal(body.m_invMass);
        body.m_linearVelocity.addLocal(vec25);
        body.m_angularVelocity += body.m_invI * Vec2.cross(vec2, vec23);
        this.pool.pushVec2(4);
    }
}

