/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.awt.Color;
import java.awt.Graphics2D;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.collision.AABB;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import org.jbox2d.pooling.arrays.IntArray;
import org.jbox2d.pooling.arrays.Vec2Array;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.pooling.ColorPool;

public class DebugDrawJ2D
extends DebugDraw {
    public static int circlePoints = 20;
    private final TestPanel panel;
    private final ColorPool cpool = new ColorPool();
    private final Vec2Array vec2Array = new Vec2Array();
    private final Vec2 sp1 = new Vec2();
    private final Vec2 sp2 = new Vec2();
    private final Vec2 saxis = new Vec2();
    private final Vec2 temp = new Vec2();
    private static final IntArray xIntsPool = new IntArray();
    private static final IntArray yIntsPool = new IntArray();
    private final Vec2 temp2 = new Vec2();

    public DebugDrawJ2D(TestPanel testPanel) {
        super(new OBBViewportTransform());
        this.viewportTransform.setYFlip(true);
        this.panel = testPanel;
    }

    public void drawCircle(Vec2 vec2, float f, Color3f color3f) {
        Vec2[] vec2Array = (Vec2[])this.vec2Array.get(circlePoints);
        this.generateCirle(vec2, f, vec2Array, circlePoints);
        this.drawPolygon(vec2Array, circlePoints, color3f);
    }

    public void drawPoint(Vec2 vec2, float f, Color3f color3f) {
        this.getWorldToScreenToOut(vec2, this.sp1);
        Graphics2D graphics2D = this.getGraphics();
        Color color = this.cpool.getColor(color3f.x, color3f.y, color3f.z);
        graphics2D.setColor(color);
        this.sp1.x -= f;
        this.sp1.y -= f;
        graphics2D.fillOval((int)this.sp1.x, (int)this.sp1.y, (int)f * 2, (int)f * 2);
    }

    public void drawSegment(Vec2 vec2, Vec2 vec22, Color3f color3f) {
        this.getWorldToScreenToOut(vec2, this.sp1);
        this.getWorldToScreenToOut(vec22, this.sp2);
        Graphics2D graphics2D = this.getGraphics();
        Color color = this.cpool.getColor(color3f.x, color3f.y, color3f.z);
        graphics2D.setColor(color);
        graphics2D.drawLine((int)this.sp1.x, (int)this.sp1.y, (int)this.sp2.x, (int)this.sp2.y);
    }

    public void drawAABB(AABB aABB, Color3f color3f) {
        Vec2[] vec2Array = (Vec2[])this.vec2Array.get(4);
        aABB.getVertices(vec2Array);
        this.drawPolygon(vec2Array, 4, color3f);
    }

    public void drawSolidCircle(Vec2 vec2, float f, Vec2 vec22, Color3f color3f) {
        Vec2[] vec2Array = (Vec2[])this.vec2Array.get(circlePoints);
        this.generateCirle(vec2, f, vec2Array, circlePoints);
        this.drawSolidPolygon(vec2Array, circlePoints, color3f);
        if (vec22 != null) {
            this.saxis.set(vec22).mulLocal(f).addLocal(vec2);
            this.drawSegment(vec2, this.saxis, color3f);
        }
    }

    public void drawSolidPolygon(Vec2[] vec2Array, int n, Color3f color3f) {
        Graphics2D graphics2D = this.getGraphics();
        int[] nArray = xIntsPool.get(n);
        int[] nArray2 = yIntsPool.get(n);
        for (int i = 0; i < n; ++i) {
            this.getWorldToScreenToOut(vec2Array[i], this.temp);
            nArray[i] = (int)this.temp.x;
            nArray2[i] = (int)this.temp.y;
        }
        Color color = this.cpool.getColor(color3f.x, color3f.y, color3f.z, 0.4f);
        graphics2D.setColor(color);
        graphics2D.fillPolygon(nArray, nArray2, n);
        this.drawPolygon(vec2Array, n, color3f);
    }

    public void drawString(float f, float f2, String string, Color3f color3f) {
        Graphics2D graphics2D = this.getGraphics();
        Color color = this.cpool.getColor(color3f.x, color3f.y, color3f.z);
        graphics2D.setColor(color);
        graphics2D.drawString(string, f, f2);
    }

    private Graphics2D getGraphics() {
        return this.panel.getDBGraphics();
    }

    public void drawTransform(Transform transform) {
        Graphics2D graphics2D = this.getGraphics();
        this.getWorldToScreenToOut(transform.position, this.temp);
        this.temp2.setZero();
        float f = 0.4f;
        Color color = this.cpool.getColor(1.0f, 0.0f, 0.0f);
        graphics2D.setColor(color);
        this.temp2.x = transform.position.x + f * transform.R.col1.x;
        this.temp2.y = transform.position.y + f * transform.R.col1.y;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        graphics2D.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
        color = this.cpool.getColor(0.0f, 1.0f, 0.0f);
        graphics2D.setColor(color);
        this.temp2.x = transform.position.x + f * transform.R.col2.x;
        this.temp2.y = transform.position.y + f * transform.R.col2.y;
        this.getWorldToScreenToOut(this.temp2, this.temp2);
        graphics2D.drawLine((int)this.temp.x, (int)this.temp.y, (int)this.temp2.x, (int)this.temp2.y);
    }

    private void generateCirle(Vec2 vec2, float f, Vec2[] vec2Array, int n) {
        float f2 = (float)Math.PI * 2 / (float)n;
        for (int i = 0; i < n; ++i) {
            vec2Array[i].x = vec2.x + MathUtils.cos((float)i * f2) * f;
            vec2Array[i].y = vec2.y + MathUtils.sin((float)i * f2) * f;
        }
    }
}

