/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.framework;

import java.util.LinkedList;
import org.jbox2d.callbacks.ContactImpulse;
import org.jbox2d.callbacks.ContactListener;
import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.callbacks.DestructionListener;
import org.jbox2d.collision.AABB;
import org.jbox2d.collision.Collision;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.WorldManifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.World;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.testbed.framework.ContactPoint;
import org.jbox2d.testbed.framework.QueueItem;
import org.jbox2d.testbed.framework.QueueItemType;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestQueryCallback;
import org.jbox2d.testbed.framework.TestbedSettings;

public abstract class TestbedTest
implements ContactListener {
    public static final int MAX_CONTACT_POINTS = 2048;
    public static final ContactPoint[] points = new ContactPoint[2048];
    public Body m_groundBody;
    protected int m_pointCount;
    private DestructionListener destructionListener;
    public DebugDraw m_debugDraw;
    public World m_world;
    protected Body m_bomb;
    public MouseJoint m_mouseJoint;
    private final Vec2 bombSpawnPoint = new Vec2();
    private boolean bombSpawning = false;
    public final Vec2 m_mouseWorld = new Vec2();
    protected int m_stepCount;
    private final LinkedList<QueueItem> inputQueue;
    private String title = null;
    protected int m_textLine;
    private final LinkedList<String> textList = new LinkedList();
    public float cachedCameraScale;
    public float cachedCameraX;
    public float cachedCameraY;
    public boolean hasCachedCamera = false;
    private TestPanel panel;
    private final Color3f color1 = new Color3f(0.3f, 0.95f, 0.3f);
    private final Color3f color2 = new Color3f(0.3f, 0.3f, 0.95f);
    private final Color3f color3 = new Color3f(0.9f, 0.9f, 0.9f);
    private final Color3f color4 = new Color3f(0.6f, 0.61f, 1.0f);
    private final Color3f mouseColor = new Color3f(0.0f, 1.0f, 0.0f);
    private final Vec2 p1 = new Vec2();
    private final Vec2 p2 = new Vec2();
    private final AABB queryAABB = new AABB();
    private final TestQueryCallback callback = new TestQueryCallback();
    private final Vec2 p = new Vec2();
    private final Vec2 v = new Vec2();
    private final AABB aabb = new AABB();
    private final Vec2 vel = new Vec2();
    private final Collision.PointState[] state1 = new Collision.PointState[Settings.maxManifoldPoints];
    private final Collision.PointState[] state2 = new Collision.PointState[Settings.maxManifoldPoints];
    private final WorldManifold worldManifold = new WorldManifold();

    public TestbedTest() {
        this.inputQueue = new LinkedList();
    }

    public void setPanel(TestPanel testPanel) {
        this.panel = testPanel;
    }

    public void init(DebugDraw debugDraw) {
        this.m_debugDraw = debugDraw;
        this.destructionListener = new DestructionListener(){

            public void sayGoodbye(Fixture fixture) {
            }

            public void sayGoodbye(Joint joint) {
                if (TestbedTest.this.m_mouseJoint == joint) {
                    TestbedTest.this.m_mouseJoint = null;
                } else {
                    TestbedTest.this.jointDestroyed(joint);
                }
            }
        };
        Vec2 vec2 = new Vec2(0.0f, -10.0f);
        this.m_world = new World(vec2, true);
        this.m_bomb = null;
        this.m_textLine = 30;
        this.m_mouseJoint = null;
        this.m_pointCount = 0;
        this.m_world.setDestructionListener(this.destructionListener);
        this.m_world.setContactListener(this);
        this.m_world.setDebugDraw(this.m_debugDraw);
        this.bombSpawning = false;
        this.m_stepCount = 0;
        BodyDef bodyDef = new BodyDef();
        this.m_groundBody = this.m_world.createBody(bodyDef);
        if (this.hasCachedCamera) {
            this.setCamera(this.cachedCameraX, this.cachedCameraY, this.cachedCameraScale);
        } else {
            this.setCamera(0.0f, 10.0f, 10.0f);
        }
        this.setTitle(this.getTestName());
        this.initTest();
    }

    public void setCamera(float f, float f2, float f3) {
        this.m_debugDraw.setCamera(f, f2, f3);
        this.hasCachedCamera = true;
        this.cachedCameraScale = f3;
        this.cachedCameraX = f;
        this.cachedCameraY = f2;
    }

    public abstract void initTest();

    public abstract String getTestName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TestbedSettings testbedSettings) {
        this.m_textLine = 15;
        if (TestPanel.keys[114]) {
            TestPanel.keys[114] = false;
            this.init(this.m_debugDraw);
        }
        if (this.title != null) {
            this.m_debugDraw.drawString(this.panel.getWidth() / 2, 15.0f, this.title, Color3f.WHITE);
        }
        if (!this.inputQueue.isEmpty()) {
            LinkedList<QueueItem> linkedList = this.inputQueue;
            synchronized (linkedList) {
                while (!this.inputQueue.isEmpty()) {
                    QueueItem queueItem = this.inputQueue.pop();
                    switch (queueItem.type) {
                        case KeyPressed: {
                            this.keyPressed(queueItem.c, queueItem.code);
                            break;
                        }
                        case KeyReleased: {
                            this.keyReleased(queueItem.c, queueItem.code);
                            break;
                        }
                        case MouseDown: {
                            this.mouseDown(queueItem.p);
                            break;
                        }
                        case MouseMove: {
                            this.mouseMove(queueItem.p);
                            break;
                        }
                        case MouseUp: {
                            this.mouseUp(queueItem.p);
                            break;
                        }
                        case ShiftMouseDown: {
                            this.shiftMouseDown(queueItem.p);
                        }
                    }
                }
            }
        }
        this.step(testbedSettings);
    }

    public void step(TestbedSettings testbedSettings) {
        float f;
        float f2 = f = testbedSettings.hz > 0.0f ? 1.0f / testbedSettings.hz : 0.0f;
        if (testbedSettings.singleStep && !testbedSettings.pause) {
            testbedSettings.pause = true;
        }
        if (testbedSettings.pause) {
            if (testbedSettings.singleStep) {
                testbedSettings.singleStep = false;
            } else {
                f = 0.0f;
            }
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "****PAUSED****", Color3f.WHITE);
            this.m_textLine += 15;
        }
        int n = 0;
        n += testbedSettings.drawShapes ? 1 : 0;
        n += testbedSettings.drawJoints ? 2 : 0;
        n += testbedSettings.drawAABBs ? 4 : 0;
        n += testbedSettings.drawPairs ? 8 : 0;
        n += testbedSettings.drawCOMs ? 16 : 0;
        this.m_debugDraw.setFlags(n += testbedSettings.drawDynamicTree ? 32 : 0);
        this.m_world.setWarmStarting(testbedSettings.enableWarmStarting);
        this.m_world.setContinuousPhysics(testbedSettings.enableContinuous);
        this.m_pointCount = 0;
        this.m_world.step(f, testbedSettings.velocityIterations, testbedSettings.positionIterations);
        this.m_world.drawDebugData();
        if (f > 0.0f) {
            ++this.m_stepCount;
        }
        if (testbedSettings.drawStats) {
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Engine Info", this.color4);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Framerate: " + this.panel.getCalculatedFrameRate(), Color3f.WHITE);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "bodies/contacts/joints/proxies = " + this.m_world.getBodyCount() + "/" + this.m_world.getContactCount() + "/" + this.m_world.getJointCount() + "/" + this.m_world.getProxyCount(), Color3f.WHITE);
            this.m_textLine += 20;
        }
        if (testbedSettings.drawHelp) {
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Help", this.color4);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Click and drag the left mouse button to move objects.", Color3f.WHITE);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Shift-Click to aim a bullet, or press space.", Color3f.WHITE);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Click and drag the right mouse button to move the view.", Color3f.WHITE);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Scroll to zoom in/out.", Color3f.WHITE);
            this.m_textLine += 15;
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Press '[' or ']' to change tests, and 'r' to restart.", Color3f.WHITE);
            this.m_textLine += 20;
        }
        if (!this.textList.isEmpty()) {
            this.m_debugDraw.drawString(5.0f, this.m_textLine, "Test Info", this.color4);
            this.m_textLine += 15;
            for (String string : this.textList) {
                this.m_debugDraw.drawString(5.0f, this.m_textLine, string, Color3f.WHITE);
                this.m_textLine += 15;
            }
            this.textList.clear();
        }
        if (this.m_mouseJoint != null) {
            this.m_mouseJoint.getAnchorB(this.p1);
            Vec2 vec2 = this.m_mouseJoint.getTarget();
            this.m_debugDraw.drawSegment(this.p1, vec2, this.mouseColor);
        }
        if (this.bombSpawning) {
            this.m_debugDraw.drawSegment(this.bombSpawnPoint, this.m_mouseWorld, Color3f.WHITE);
        }
        if (testbedSettings.drawContactPoints) {
            for (int i = 0; i < this.m_pointCount; ++i) {
                ContactPoint contactPoint = points[i];
                if (contactPoint.state == Collision.PointState.ADD_STATE) {
                    this.m_debugDraw.drawPoint(contactPoint.position, 10.0f, this.color1);
                } else if (contactPoint.state == Collision.PointState.PERSIST_STATE) {
                    this.m_debugDraw.drawPoint(contactPoint.position, 5.0f, this.color2);
                }
                if (!testbedSettings.drawContactNormals) continue;
                this.p1.set(contactPoint.position);
                this.p2.set(contactPoint.normal).mulLocal(0.3f).addLocal(this.p1);
                this.m_debugDraw.drawSegment(this.p1, this.p2, this.color3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueShiftMouseDown(Vec2 vec2) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.ShiftMouseDown, vec2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseUp(Vec2 vec2) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseUp, vec2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseDown(Vec2 vec2) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseDown, vec2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueMouseMove(Vec2 vec2) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.MouseMove, vec2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyPressed(char c, int n) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.KeyPressed, c, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueKeyReleased(char c, int n) {
        LinkedList<QueueItem> linkedList = this.inputQueue;
        synchronized (linkedList) {
            this.inputQueue.addLast(new QueueItem(QueueItemType.KeyReleased, c, n));
        }
    }

    public void shiftMouseDown(Vec2 vec2) {
        this.m_mouseWorld.set(vec2);
        if (this.m_mouseJoint != null) {
            return;
        }
        this.spawnBomb(vec2);
    }

    public void mouseUp(Vec2 vec2) {
        if (this.m_mouseJoint != null) {
            this.m_world.destroyJoint(this.m_mouseJoint);
            this.m_mouseJoint = null;
        }
        if (this.bombSpawning) {
            this.completeBombSpawn(vec2);
        }
    }

    public void mouseDown(Vec2 vec2) {
        this.m_mouseWorld.set(vec2);
        if (this.m_mouseJoint != null) {
            return;
        }
        this.queryAABB.lowerBound.set(vec2.x - 0.001f, vec2.y - 0.001f);
        this.queryAABB.upperBound.set(vec2.x + 0.001f, vec2.y + 0.001f);
        this.callback.point.set(vec2);
        this.callback.fixture = null;
        this.m_world.queryAABB(this.callback, this.queryAABB);
        if (this.callback.fixture != null) {
            Body body = this.callback.fixture.getBody();
            MouseJointDef mouseJointDef = new MouseJointDef();
            mouseJointDef.bodyA = this.m_groundBody;
            mouseJointDef.bodyB = body;
            mouseJointDef.target.set(vec2);
            mouseJointDef.maxForce = 1000.0f * body.getMass();
            this.m_mouseJoint = (MouseJoint)this.m_world.createJoint(mouseJointDef);
            body.setAwake(true);
        }
    }

    public void mouseMove(Vec2 vec2) {
        this.m_mouseWorld.set(vec2);
        if (this.m_mouseJoint != null) {
            this.m_mouseJoint.setTarget(vec2);
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void addTextLine(String string) {
        this.textList.add(string);
    }

    public void lanchBomb() {
        this.p.set((float)(Math.random() * 30.0 - 15.0), 30.0f);
        this.v.set(this.p).mulLocal(-5.0f);
        this.launchBomb(this.p, this.v);
    }

    public void launchBomb(Vec2 vec2, Vec2 vec22) {
        if (this.m_bomb != null) {
            this.m_world.destroyBody(this.m_bomb);
            this.m_bomb = null;
        }
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(vec2);
        bodyDef.bullet = true;
        this.m_bomb = this.m_world.createBody(bodyDef);
        this.m_bomb.setLinearVelocity(vec22);
        CircleShape circleShape = new CircleShape();
        circleShape.m_radius = 0.3f;
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = circleShape;
        fixtureDef.density = 20.0f;
        fixtureDef.restitution = 0.0f;
        Vec2 vec23 = new Vec2(vec2);
        Vec2 vec24 = new Vec2(vec2);
        vec23.subLocal(new Vec2(0.3f, 0.3f));
        vec24.addLocal(new Vec2(0.3f, 0.3f));
        this.aabb.lowerBound.set(vec23);
        this.aabb.upperBound.set(vec24);
        this.m_bomb.createFixture(fixtureDef);
    }

    public void spawnBomb(Vec2 vec2) {
        this.bombSpawnPoint.set(vec2);
        this.bombSpawning = true;
    }

    public void completeBombSpawn(Vec2 vec2) {
        if (!this.bombSpawning) {
            return;
        }
        float f = 30.0f;
        this.vel.set(this.bombSpawnPoint).subLocal(vec2);
        this.vel.mulLocal(f);
        this.launchBomb(this.bombSpawnPoint, this.vel);
        this.bombSpawning = false;
    }

    public void jointDestroyed(Joint joint) {
    }

    public void beginContact(Contact contact) {
    }

    public void endContact(Contact contact) {
    }

    public void postSolve(Contact contact, ContactImpulse contactImpulse) {
    }

    public void preSolve(Contact contact, Manifold manifold) {
        Manifold manifold2 = contact.getManifold();
        if (manifold2.pointCount == 0) {
            return;
        }
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        Collision.getPointStates(this.state1, this.state2, manifold, manifold2);
        contact.getWorldManifold(this.worldManifold);
        for (int i = 0; i < manifold2.pointCount && this.m_pointCount < 2048; ++i) {
            ContactPoint contactPoint = points[this.m_pointCount];
            contactPoint.fixtureA = fixture;
            contactPoint.fixtureB = fixture2;
            contactPoint.position.set(this.worldManifold.points[i]);
            contactPoint.normal.set(this.worldManifold.normal);
            contactPoint.state = this.state2[i];
            ++this.m_pointCount;
        }
    }

    public void keyPressed(char c, int n) {
    }

    public void keyReleased(char c, int n) {
    }

    static {
        for (int i = 0; i < 2048; ++i) {
            TestbedTest.points[i] = new ContactPoint();
        }
    }
}

