/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.perf;

import org.jbox2d.common.MathUtils;
import org.jbox2d.testbed.perf.PerfTest;

public class MathPerf
extends PerfTest {
    public static int INNER_ITERS = 500000;
    public static int OUTER_ITERS = 100;
    String[] tests = new String[]{"Sin", "SinLUT", "Pow", "FastPow", "Max", "FastMax", "Floor", "fastFloor", "aTan2", "fastATan2", "ceil", "fastCeil"};
    public float aStore = 0.0f;

    public MathPerf() {
        super(12, OUTER_ITERS);
    }

    public void runTest(int n) {
        float f = MathUtils.randomFloat(0.0f, 1.1342745E38f);
        switch (n) {
            case 0: {
                this.runSinTest(f);
                break;
            }
            case 1: {
                this.runSinLUTTest(f);
                break;
            }
            case 2: {
                this.runPowTest(f);
                break;
            }
            case 3: {
                this.runFastPowTest(f);
                break;
            }
            case 4: {
                this.runMaxTest(f);
                break;
            }
            case 5: {
                this.runFastMaxTest(f);
                break;
            }
            case 6: {
                this.runFloorTest(f);
                break;
            }
            case 7: {
                this.runFastFloorTest(f);
                break;
            }
            case 8: {
                this.runAtan2Test(f);
                break;
            }
            case 9: {
                this.runFastAtan2Test(f);
                break;
            }
            case 10: {
                this.runCeilTest(f);
                break;
            }
            case 11: {
                this.runFastCeilTest(f);
            }
        }
    }

    public void runSinTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = (float)StrictMath.sin(f);
        }
        this.aStore += f2;
    }

    public void runSinLUTTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.sinLUT(f);
        }
        this.aStore += f2;
    }

    public void runPowTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = (float)StrictMath.pow(f, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += f2;
    }

    public void runFastPowTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.fastPow(f, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += f2;
    }

    public void runMaxTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = StrictMath.max(f, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += f2;
    }

    public void runFastMaxTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.max(f, MathUtils.randomFloat(-100.0f, 100.0f));
        }
        this.aStore += f2;
    }

    public void runFloorTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = (float)StrictMath.floor(f);
        }
        this.aStore += f2;
    }

    public void runFastFloorTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.floor(f);
        }
        this.aStore += f2;
    }

    public void runAtan2Test(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = (float)StrictMath.atan2(f, MathUtils.randomFloat(-10000.0f, 10000.0f));
        }
        this.aStore += f2;
    }

    public void runFastAtan2Test(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.fastAtan2(f, MathUtils.randomFloat(-10000.0f, 10000.0f));
        }
        this.aStore += f2;
    }

    public void runCeilTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = (float)StrictMath.ceil(f);
        }
        this.aStore += f2;
    }

    public void runFastCeilTest(float f) {
        float f2 = 0.0f;
        for (int i = 0; i < INNER_ITERS; ++i) {
            f2 = MathUtils.ceil(f);
        }
        this.aStore += f2;
    }

    public String getTestName(int n) {
        return this.tests[n];
    }

    public static void main(String[] stringArray) {
        MathPerf mathPerf = new MathPerf();
        mathPerf.go();
    }
}

