/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class BodyTypes
extends TestbedTest {
    Body m_attachment;
    Body m_platform;
    float m_speed;

    public void initTest() {
        Body body = null;
        BodyDef bodyDef = new BodyDef();
        body = this.m_world.createBody(bodyDef);
        Object object = new PolygonShape();
        ((PolygonShape)object).setAsEdge(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        Object object2 = new FixtureDef();
        ((FixtureDef)object2).shape = object;
        body.createFixture((FixtureDef)object2);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 3.0f);
        this.m_attachment = this.m_world.createBody(bodyDef);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(0.5f, 2.0f);
        this.m_attachment.createFixture((Shape)object, 2.0f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(-4.0f, 5.0f);
        this.m_platform = this.m_world.createBody(bodyDef);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(0.5f, 4.0f, new Vec2(4.0f, 0.0f), 1.5707964f);
        object2 = new FixtureDef();
        ((FixtureDef)object2).shape = object;
        ((FixtureDef)object2).friction = 0.6f;
        ((FixtureDef)object2).density = 2.0f;
        this.m_platform.createFixture((FixtureDef)object2);
        Object object3 = new RevoluteJointDef();
        ((RevoluteJointDef)object3).initialize(this.m_attachment, this.m_platform, new Vec2(0.0f, 5.0f));
        ((RevoluteJointDef)object3).maxMotorTorque = 50.0f;
        ((RevoluteJointDef)object3).enableMotor = true;
        this.m_world.createJoint((JointDef)object3);
        PrismaticJointDef prismaticJointDef = new PrismaticJointDef();
        prismaticJointDef.initialize(body, this.m_platform, new Vec2(0.0f, 5.0f), new Vec2(1.0f, 0.0f));
        prismaticJointDef.maxMotorForce = 1000.0f;
        prismaticJointDef.enableMotor = true;
        prismaticJointDef.lowerTranslation = -10.0f;
        prismaticJointDef.upperTranslation = 10.0f;
        prismaticJointDef.enableLimit = true;
        this.m_world.createJoint(prismaticJointDef);
        this.m_speed = 3.0f;
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 8.0f);
        object = this.m_world.createBody(bodyDef);
        object2 = new PolygonShape();
        ((PolygonShape)object2).setAsBox(0.75f, 0.75f);
        object3 = new FixtureDef();
        ((FixtureDef)object3).shape = object2;
        ((FixtureDef)object3).friction = 0.6f;
        ((FixtureDef)object3).density = 2.0f;
        ((Body)object).createFixture((FixtureDef)object3);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Keys: (d) dynamic, (s) static, (k) kinematic");
        if (this.m_platform.getType() == BodyType.KINEMATIC) {
            Vec2 vec2 = this.m_platform.getTransform().position;
            Vec2 vec22 = this.m_platform.getLinearVelocity();
            if (vec2.x < -10.0f && vec22.x < 0.0f || vec2.x > 10.0f && vec22.x > 0.0f) {
                vec22.x = -vec22.x;
                this.m_platform.setLinearVelocity(vec22);
            }
        }
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'd': {
                this.m_platform.setType(BodyType.DYNAMIC);
                break;
            }
            case 's': {
                this.m_platform.setType(BodyType.STATIC);
                break;
            }
            case 'k': {
                this.m_platform.setType(BodyType.KINEMATIC);
                this.m_platform.setLinearVelocity(new Vec2(-this.m_speed, 0.0f));
                this.m_platform.setAngularVelocity(0.0f);
            }
        }
    }

    public String getTestName() {
        return "Body Types";
    }
}

