/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class CircleStress
extends TestbedTest {
    private boolean firstTime = true;
    private RevoluteJoint joint;

    public void initTest() {
        if (this.firstTime) {
            this.setCamera(0.0f, 20.0f, 5.0f);
            this.firstTime = false;
        }
        Object object = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)object);
        Shape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(shape, 0.0f);
        object = null;
        body = null;
        shape = new PolygonShape();
        shape.setAsBox(50.0f, 10.0f);
        Object object2 = new BodyDef();
        ((BodyDef)object2).type = BodyType.STATIC;
        ((BodyDef)object2).position = new Vec2(0.0f, -10.0f);
        Object object3 = this.m_world.createBody((BodyDef)object2);
        FixtureDef fixtureDef = new FixtureDef();
        fixtureDef.shape = shape;
        fixtureDef.friction = 1.0f;
        ((Body)object3).createFixture(fixtureDef);
        shape.setAsBox(3.0f, 50.0f);
        object2 = new BodyDef();
        ((BodyDef)object2).position = new Vec2(45.0f, 25.0f);
        body = this.m_world.createBody((BodyDef)object2);
        body.createFixture(shape, 0.0f);
        ((BodyDef)object2).position = new Vec2(-45.0f, 25.0f);
        object = this.m_world.createBody((BodyDef)object2);
        ((Body)object).createFixture(shape, 0.0f);
        object2 = new BodyDef();
        shape.setAsBox(20.0f, 3.0f);
        ((BodyDef)object2).angle = -0.7853982f;
        ((BodyDef)object2).position = new Vec2(-35.0f, 8.0f);
        Body body2 = this.m_world.createBody((BodyDef)object2);
        body2.createFixture(shape, 0.0f);
        ((BodyDef)object2).angle = 0.7853982f;
        ((BodyDef)object2).position = new Vec2(35.0f, 8.0f);
        body2 = this.m_world.createBody((BodyDef)object2);
        body2.createFixture(shape, 0.0f);
        shape.setAsBox(50.0f, 10.0f);
        ((BodyDef)object2).type = BodyType.STATIC;
        ((BodyDef)object2).angle = 0.0f;
        ((BodyDef)object2).position = new Vec2(0.0f, 75.0f);
        object3 = this.m_world.createBody((BodyDef)object2);
        fixtureDef.shape = shape;
        fixtureDef.friction = 1.0f;
        ((Body)object3).createFixture(fixtureDef);
        object2 = new FixtureDef();
        object3 = new BodyDef();
        ((BodyDef)object3).type = BodyType.DYNAMIC;
        int n = 5;
        float f = 6.0f;
        ((BodyDef)object3).position = new Vec2(0.0f, 10.0f);
        Body body3 = this.m_world.createBody((BodyDef)object3);
        for (int i = 0; i < n; ++i) {
            shape = new CircleShape();
            ((CircleShape)shape).m_radius = 1.2f;
            ((FixtureDef)object2).shape = shape;
            ((FixtureDef)object2).density = 25.0f;
            ((FixtureDef)object2).friction = 0.1f;
            ((FixtureDef)object2).restitution = 0.9f;
            float f2 = f * (float)Math.cos(Math.PI * 2 * (double)((float)i / (float)n));
            float f3 = f * (float)Math.sin(Math.PI * 2 * (double)((float)i / (float)n));
            ((CircleShape)shape).m_p.set(f2, f3);
            body3.createFixture((FixtureDef)object2);
        }
        body3.setBullet(false);
        RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.initialize(body3, this.m_groundBody, body3.getPosition());
        revoluteJointDef.motorSpeed = (float)Math.PI;
        revoluteJointDef.maxMotorTorque = 1000000.0f;
        revoluteJointDef.enableMotor = true;
        this.joint = (RevoluteJoint)this.m_world.createJoint(revoluteJointDef);
        int n2 = 41;
        for (int i = 0; i < 15; ++i) {
            for (int j = 0; j < n2; ++j) {
                CircleShape circleShape = new CircleShape();
                BodyDef bodyDef = new BodyDef();
                bodyDef.type = BodyType.DYNAMIC;
                circleShape.m_radius = 1.0f + (j % 2 == 0 ? 1.0f : -1.0f) * 0.5f * MathUtils.randomFloat(0.5f, 1.0f);
                FixtureDef fixtureDef2 = new FixtureDef();
                fixtureDef2.shape = circleShape;
                fixtureDef2.density = circleShape.m_radius * 1.5f;
                fixtureDef2.friction = 0.5f;
                fixtureDef2.restitution = 0.7f;
                float f4 = -39.0f + (float)(2 * j);
                float f5 = 50.0f + (float)i;
                bodyDef.position = new Vec2(f4, f5);
                Body body4 = this.m_world.createBody(bodyDef);
                body4.createFixture(fixtureDef2);
            }
        }
        this.m_world.setGravity(new Vec2(0.0f, -50.0f));
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 's': {
                this.joint.setMotorSpeed(0.0f);
                break;
            }
            case '1': {
                this.joint.setMotorSpeed((float)Math.PI);
                break;
            }
            case '2': {
                this.joint.setMotorSpeed((float)Math.PI * 2);
                break;
            }
            case '3': {
                this.joint.setMotorSpeed((float)Math.PI * 3);
                break;
            }
            case '4': {
                this.joint.setMotorSpeed((float)Math.PI * 6);
                break;
            }
            case '5': {
                this.joint.setMotorSpeed((float)Math.PI * 10);
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Press 's' to stop, and '1' - '5' to change speeds");
    }

    public String getTestName() {
        return "Circle Stress Test";
    }
}

