/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Distance;
import org.jbox2d.collision.TimeOfImpact;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ContinuousTest
extends TestbedTest {
    Body m_body;
    Fixture currFixture;
    PolygonShape m_poly;
    CircleShape m_circle;
    Shape nextShape = null;
    boolean polygon = false;
    float m_angularVelocity;

    public String getTestName() {
        return "Continuous";
    }

    public void switchObjects() {
        this.nextShape = this.polygon ? this.m_circle : this.m_poly;
        this.polygon = !this.polygon;
    }

    public void initTest() {
        BodyDef bodyDef = new BodyDef();
        bodyDef.position.set(0.0f, 0.0f);
        Body body = this.m_world.createBody(bodyDef);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-10.0f, 0.0f), new Vec2(10.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        polygonShape.setAsBox(0.2f, 1.0f, new Vec2(0.5f, 1.0f), 0.0f);
        body.createFixture(polygonShape, 0.0f);
        this.m_poly = new PolygonShape();
        this.m_poly.setAsBox(2.0f, 0.1f);
        this.m_circle = new CircleShape();
        this.m_circle.m_p.setZero();
        this.m_circle.m_radius = 0.5f;
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 20.0f);
        this.m_body = this.m_world.createBody(bodyDef);
        this.currFixture = this.m_body.createFixture(this.m_poly, 1.0f);
        this.m_angularVelocity = (float)Math.random() * 100.0f - 50.0f;
        this.m_angularVelocity = 33.46812f;
        this.m_body.setLinearVelocity(new Vec2(0.0f, -100.0f));
        this.m_body.setAngularVelocity(this.m_angularVelocity);
        TimeOfImpact.toiCalls = 0;
        TimeOfImpact.toiIters = 0;
        TimeOfImpact.toiMaxIters = 0;
        TimeOfImpact.toiRootIters = 0;
        TimeOfImpact.toiMaxRootIters = 0;
    }

    public void launch() {
        this.m_body.setTransform(new Vec2(0.0f, 20.0f), 0.0f);
        this.m_angularVelocity = (float)Math.random() * 100.0f - 50.0f;
        this.m_body.setLinearVelocity(new Vec2(0.0f, -100.0f));
        this.m_body.setAngularVelocity(this.m_angularVelocity);
    }

    public void step(TestbedSettings testbedSettings) {
        if (this.nextShape != null) {
            this.m_body.destroyFixture(this.currFixture);
            this.currFixture = this.m_body.createFixture(this.nextShape, 1.0f);
            this.nextShape = null;
        }
        super.step(testbedSettings);
        if (Distance.GJK_CALLS > 0) {
            this.addTextLine(String.format("gjk calls = %d, ave gjk iters = %3.1f, max gjk iters = %d", Distance.GJK_CALLS, (double)Distance.GJK_ITERS * 1.0 / (double)Distance.GJK_CALLS, Distance.GJK_MAX_ITERS));
        }
        if (TimeOfImpact.toiCalls > 0) {
            int n = TimeOfImpact.toiCalls;
            int n2 = TimeOfImpact.toiIters;
            int n3 = TimeOfImpact.toiMaxIters;
            int n4 = TimeOfImpact.toiRootIters;
            int n5 = TimeOfImpact.toiMaxRootIters;
            this.addTextLine(String.format("toi calls = %d, ave toi iters = %3.1f, max toi iters = %d", n, (double)n2 * 1.0 / (double)n, n3));
            this.addTextLine(String.format("ave toi root iters = %3.1f, max toi root iters = %d", (double)n4 * 1.0 / (double)n, n5));
        }
        this.addTextLine("Press 'c' to change launch shape");
        if (this.m_stepCount % 60 == 0) {
            this.launch();
        }
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'c': {
                this.switchObjects();
            }
        }
    }
}

