/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.EdgeShapesCallback;

public class EdgeShapes
extends TestbedTest {
    int e_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies = new Body[this.e_maxBodies];
    PolygonShape[] m_polygons = new PolygonShape[4];
    CircleShape m_circle;
    float m_angle;
    EdgeShapesCallback callback = new EdgeShapesCallback();

    public void initTest() {
        Vec2[] vec2Array = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)vec2Array);
        float f = -20.0f;
        float f2 = 2.0f * MathUtils.cos(f / 10.0f * (float)Math.PI);
        for (int i = 0; i < 80; ++i) {
            float f3 = f + 0.5f;
            float f4 = 2.0f * MathUtils.cos(f3 / 10.0f * (float)Math.PI);
            PolygonShape polygonShape = new PolygonShape();
            polygonShape.setAsEdge(new Vec2(f, f2), new Vec2(f3, f4));
            body.createFixture(polygonShape, 0.0f);
            f = f3;
            f2 = f4;
        }
        vec2Array = new Vec2[]{new Vec2(-0.5f, 0.0f), new Vec2(0.5f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vec2Array, 3);
        vec2Array = new Vec2[]{new Vec2(-0.1f, 0.0f), new Vec2(0.1f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vec2Array, 3);
        float f5 = 1.0f;
        float f6 = f5 / (2.0f + MathUtils.sqrt(2.0f));
        f = MathUtils.sqrt(2.0f) * f6;
        Vec2[] vec2Array2 = new Vec2[]{new Vec2(0.5f * f, 0.0f), new Vec2(0.5f * f5, f6), new Vec2(0.5f * f5, f6 + f), new Vec2(0.5f * f, f5), new Vec2(-0.5f * f, f5), new Vec2(-0.5f * f5, f6 + f), new Vec2(-0.5f * f5, f6), new Vec2(-0.5f * f, 0.0f)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vec2Array2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5f, 0.5f);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5f;
        this.m_bodyIndex = 0;
        this.m_angle = 0.0f;
    }

    void Create(int n) {
        if (this.m_bodies[this.m_bodyIndex] != null) {
            this.m_world.destroyBody(this.m_bodies[this.m_bodyIndex]);
            this.m_bodies[this.m_bodyIndex] = null;
        }
        BodyDef bodyDef = new BodyDef();
        float f = MathUtils.randomFloat(-10.0f, 10.0f);
        float f2 = MathUtils.randomFloat(10.0f, 20.0f);
        bodyDef.position.set(f, f2);
        bodyDef.angle = MathUtils.randomFloat((float)(-Math.PI), (float)Math.PI);
        bodyDef.type = BodyType.DYNAMIC;
        if (n == 4) {
            bodyDef.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.m_world.createBody(bodyDef);
        if (n < 4) {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_polygons[n];
            fixtureDef.friction = 0.3f;
            fixtureDef.density = 20.0f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        } else {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_circle;
            fixtureDef.friction = 0.3f;
            fixtureDef.density = 20.0f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % this.e_maxBodies;
    }

    void DestroyBody() {
        for (int i = 0; i < this.e_maxBodies; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.m_world.destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(c - 49);
                break;
            }
            case 'd': {
                this.DestroyBody();
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        boolean bl = !testbedSettings.pause || testbedSettings.singleStep;
        super.step(testbedSettings);
        this.addTextLine("Press 1-5 to drop stuff");
        float f = 25.0f;
        Vec2 vec2 = new Vec2(0.0f, 10.0f);
        Vec2 vec22 = new Vec2(f * MathUtils.cos(this.m_angle), -f * MathUtils.abs(MathUtils.sin(this.m_angle)));
        Vec2 vec23 = vec2.add(vec22);
        this.callback.m_fixture = null;
        this.m_world.raycast(this.callback, vec2, vec23);
        if (this.callback.m_fixture != null) {
            this.m_debugDraw.drawPoint(this.callback.m_point, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
            this.m_debugDraw.drawSegment(vec2, this.callback.m_point, new Color3f(0.8f, 0.8f, 0.8f));
            Vec2 vec24 = this.callback.m_normal.mul(0.5f).addLocal(this.callback.m_point);
            this.m_debugDraw.drawSegment(this.callback.m_point, vec24, new Color3f(0.9f, 0.9f, 0.4f));
        } else {
            this.m_debugDraw.drawSegment(vec2, vec23, new Color3f(0.8f, 0.8f, 0.8f));
        }
        if (bl) {
            this.m_angle += 0.004363323f;
        }
    }

    public String getTestName() {
        return "Edge Shapes";
    }
}

