/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class Gears
extends TestbedTest {
    RevoluteJoint m_joint1;
    RevoluteJoint m_joint2;
    PrismaticJoint m_joint3;
    GearJoint m_joint4;
    GearJoint m_joint5;

    public void initTest() {
        Body body = null;
        Object object = new BodyDef();
        body = this.m_world.createBody((BodyDef)object);
        Shape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(50.0f, 0.0f), new Vec2(-50.0f, 0.0f));
        body.createFixture(shape, 0.0f);
        object = new CircleShape();
        ((CircleShape)object).m_radius = 1.0f;
        shape = new CircleShape();
        ((CircleShape)shape).m_radius = 2.0f;
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsBox(0.5f, 5.0f);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(-3.0f, 12.0f);
        Body body2 = this.m_world.createBody(bodyDef);
        body2.createFixture((Shape)object, 5.0f);
        RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.bodyA = body;
        revoluteJointDef.bodyB = body2;
        revoluteJointDef.localAnchorA = body.getLocalPoint(bodyDef.position);
        revoluteJointDef.localAnchorB = body2.getLocalPoint(bodyDef.position);
        revoluteJointDef.referenceAngle = body2.getAngle() - body.getAngle();
        this.m_joint1 = (RevoluteJoint)this.m_world.createJoint(revoluteJointDef);
        BodyDef bodyDef2 = new BodyDef();
        bodyDef2.type = BodyType.DYNAMIC;
        bodyDef2.position.set(0.0f, 12.0f);
        Body body3 = this.m_world.createBody(bodyDef2);
        body3.createFixture(shape, 5.0f);
        RevoluteJointDef revoluteJointDef2 = new RevoluteJointDef();
        revoluteJointDef2.initialize(body, body3, bodyDef2.position);
        this.m_joint2 = (RevoluteJoint)this.m_world.createJoint(revoluteJointDef2);
        BodyDef bodyDef3 = new BodyDef();
        bodyDef3.type = BodyType.DYNAMIC;
        bodyDef3.position.set(2.5f, 12.0f);
        Body body4 = this.m_world.createBody(bodyDef3);
        body4.createFixture(polygonShape, 5.0f);
        PrismaticJointDef prismaticJointDef = new PrismaticJointDef();
        prismaticJointDef.initialize(body, body4, bodyDef3.position, new Vec2(0.0f, 1.0f));
        prismaticJointDef.lowerTranslation = -5.0f;
        prismaticJointDef.upperTranslation = 5.0f;
        prismaticJointDef.enableLimit = true;
        this.m_joint3 = (PrismaticJoint)this.m_world.createJoint(prismaticJointDef);
        GearJointDef gearJointDef = new GearJointDef();
        gearJointDef.bodyA = body2;
        gearJointDef.bodyB = body3;
        gearJointDef.joint1 = this.m_joint1;
        gearJointDef.joint2 = this.m_joint2;
        gearJointDef.ratio = ((CircleShape)shape).m_radius / ((CircleShape)object).m_radius;
        this.m_joint4 = (GearJoint)this.m_world.createJoint(gearJointDef);
        GearJointDef gearJointDef2 = new GearJointDef();
        gearJointDef2.bodyA = body3;
        gearJointDef2.bodyB = body4;
        gearJointDef2.joint1 = this.m_joint2;
        gearJointDef2.joint2 = this.m_joint3;
        gearJointDef2.ratio = -1.0f / ((CircleShape)shape).m_radius;
        this.m_joint5 = (GearJoint)this.m_world.createJoint(gearJointDef2);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        float f = this.m_joint4.getRatio();
        float f2 = this.m_joint1.getJointAngle() + f * this.m_joint2.getJointAngle();
        this.addTextLine("theta1 + " + f + " * theta2 = " + f2);
        f = this.m_joint5.getRatio();
        f2 = this.m_joint2.getJointAngle() + f * this.m_joint3.getJointTranslation();
        this.addTextLine("theta2 + " + f + " * delta = " + f2);
    }

    public String getTestName() {
        return "Gears";
    }
}

