/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Settings;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.testbed.framework.TestbedTest;

public class OneSidedTest
extends TestbedTest {
    float m_radius;
    float m_top;
    float m_bottom;
    State m_state;
    Fixture m_platform;
    Fixture m_character;

    public String getTestName() {
        return "One Sided";
    }

    public void initTest() {
        BodyDef bodyDef = new BodyDef();
        Body body = this.m_world.createBody(bodyDef);
        Shape shape = new PolygonShape();
        shape.setAsEdge(new Vec2(-20.0f, 0.0f), new Vec2(20.0f, 0.0f));
        body.createFixture(shape, 0.0f);
        bodyDef = new BodyDef();
        bodyDef.position.set(0.0f, 10.0f);
        body = this.m_world.createBody(bodyDef);
        shape = new PolygonShape();
        shape.setAsBox(3.0f, 0.5f);
        this.m_platform = body.createFixture(shape, 0.0f);
        this.m_bottom = 9.5f;
        this.m_top = 10.5f;
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 12.0f);
        body = this.m_world.createBody(bodyDef);
        this.m_radius = 0.5f;
        shape = new CircleShape();
        ((CircleShape)shape).m_radius = this.m_radius;
        this.m_character = body.createFixture(shape, 20.0f);
        body.setLinearVelocity(new Vec2(0.0f, -50.0f));
        this.m_state = State.e_unknown;
    }

    public void preSolve(Contact contact, Manifold manifold) {
        super.preSolve(contact, manifold);
        Fixture fixture = contact.getFixtureA();
        Fixture fixture2 = contact.getFixtureB();
        if (fixture != this.m_platform && fixture != this.m_character) {
            return;
        }
        if (fixture2 != this.m_character && fixture2 != this.m_character) {
            return;
        }
        Vec2 vec2 = this.m_character.getBody().getPosition();
        if (vec2.y < this.m_top + this.m_radius - 3.0f * Settings.linearSlop) {
            contact.setEnabled(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class State
    extends Enum<State> {
        public static final /* enum */ State e_unknown = new State();
        public static final /* enum */ State e_above = new State();
        public static final /* enum */ State e_below = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        static {
            $VALUES = new State[]{e_unknown, e_above, e_below};
        }
    }
}

