/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.AABB;
import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.PolyShapesCallback;

public class PolyShapes
extends TestbedTest {
    int k_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies = new Body[this.k_maxBodies];
    PolygonShape[] m_polygons = new PolygonShape[4];
    CircleShape m_circle;

    public void initTest() {
        Vec2[] vec2Array = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)vec2Array);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        vec2Array = new Vec2[]{new Vec2(-0.5f, 0.0f), new Vec2(0.5f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vec2Array, 3);
        vec2Array = new Vec2[]{new Vec2(-0.1f, 0.0f), new Vec2(0.1f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vec2Array, 3);
        float f = 1.0f;
        float f2 = f / (2.0f + MathUtils.sqrt(2.0f));
        float f3 = MathUtils.sqrt(2.0f) * f2;
        Vec2[] vec2Array2 = new Vec2[]{new Vec2(0.5f * f3, 0.0f), new Vec2(0.5f * f, f2), new Vec2(0.5f * f, f2 + f3), new Vec2(0.5f * f3, f), new Vec2(-0.5f * f3, f), new Vec2(-0.5f * f, f2 + f3), new Vec2(-0.5f * f, f2), new Vec2(-0.5f * f3, 0.0f)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vec2Array2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5f, 0.5f);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5f;
        this.m_bodyIndex = 0;
    }

    void Create(int n) {
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        float f = MathUtils.randomFloat(-2.0f, 2.0f);
        bodyDef.position.set(f, 10.0f);
        bodyDef.angle = MathUtils.randomFloat((float)(-Math.PI), (float)Math.PI);
        if (n == 4) {
            bodyDef.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.m_world.createBody(bodyDef);
        if (n < 4) {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_polygons[n];
            fixtureDef.density = 1.0f;
            fixtureDef.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        } else {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_circle;
            fixtureDef.density = 1.0f;
            fixtureDef.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % this.k_maxBodies;
    }

    void DestroyBody() {
        for (int i = 0; i < this.k_maxBodies; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.m_world.destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(c - 49);
                break;
            }
            case 'a': {
                for (int i = 0; i < this.k_maxBodies; i += 2) {
                    if (this.m_bodies[i] == null) continue;
                    boolean bl = this.m_bodies[i].isActive();
                    this.m_bodies[i].setActive(!bl);
                }
                break;
            }
            case 'd': {
                this.DestroyBody();
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        PolyShapesCallback polyShapesCallback = new PolyShapesCallback(this.m_world.getPool());
        polyShapesCallback.m_circle.m_radius = 2.0f;
        polyShapesCallback.m_circle.m_p.set(0.0f, 2.1f);
        polyShapesCallback.m_transform.setIdentity();
        polyShapesCallback.debugDraw = this.m_debugDraw;
        AABB aABB = new AABB();
        polyShapesCallback.m_circle.computeAABB(aABB, polyShapesCallback.m_transform);
        this.m_world.queryAABB(polyShapesCallback, aABB);
        Color3f color3f = new Color3f(0.4f, 0.7f, 0.8f);
        this.m_debugDraw.drawCircle(polyShapesCallback.m_circle.m_p, polyShapesCallback.m_circle.m_radius, color3f);
        this.addTextLine("Press 1-5 to drop stuff");
        this.addTextLine("Press 'a' to (de)activate some bodies");
        this.addTextLine("Press 'd' to destroy a body");
        this.addTextLine("Up to 30 bodies in the target circle are highlighted");
    }

    public String getTestName() {
        return "PolyShapes";
    }
}

