/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.FixtureDef;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;
import org.jbox2d.testbed.tests.RayCastAnyCallback;
import org.jbox2d.testbed.tests.RayCastClosestCallback;
import org.jbox2d.testbed.tests.RayCastMultipleCallback;

public class RayCastTest
extends TestbedTest {
    public static final int e_maxBodies = 256;
    int m_bodyIndex;
    Body[] m_bodies;
    Integer[] m_userData;
    PolygonShape[] m_polygons;
    CircleShape m_circle;
    float m_angle;
    Mode m_mode;
    RayCastClosestCallback ccallback = new RayCastClosestCallback();
    RayCastAnyCallback acallback = new RayCastAnyCallback();
    RayCastMultipleCallback mcallback = new RayCastMultipleCallback();
    Vec2 point1 = new Vec2();
    Vec2 d = new Vec2();
    Vec2 pooledHead = new Vec2();
    Vec2 point2 = new Vec2();

    public String getTestName() {
        return "Raycast";
    }

    public void initTest() {
        this.m_bodies = new Body[256];
        this.m_userData = new Integer[256];
        this.m_polygons = new PolygonShape[4];
        Vec2[] vec2Array = new BodyDef();
        Body body = this.m_world.createBody((BodyDef)vec2Array);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        vec2Array = new Vec2[]{new Vec2(-0.5f, 0.0f), new Vec2(0.5f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[0] = new PolygonShape();
        this.m_polygons[0].set(vec2Array, 3);
        vec2Array = new Vec2[]{new Vec2(-0.1f, 0.0f), new Vec2(0.1f, 0.0f), new Vec2(0.0f, 1.5f)};
        this.m_polygons[1] = new PolygonShape();
        this.m_polygons[1].set(vec2Array, 3);
        float f = 1.0f;
        float f2 = f / (2.0f + MathUtils.sqrt(2.0f));
        float f3 = MathUtils.sqrt(2.0f) * f2;
        Vec2[] vec2Array2 = new Vec2[]{new Vec2(0.5f * f3, 0.0f), new Vec2(0.5f * f, f2), new Vec2(0.5f * f, f2 + f3), new Vec2(0.5f * f3, f), new Vec2(-0.5f * f3, f), new Vec2(-0.5f * f, f2 + f3), new Vec2(-0.5f * f, f2), new Vec2(-0.5f * f3, 0.0f)};
        this.m_polygons[2] = new PolygonShape();
        this.m_polygons[2].set(vec2Array2, 8);
        this.m_polygons[3] = new PolygonShape();
        this.m_polygons[3].setAsBox(0.5f, 0.5f);
        this.m_circle = new CircleShape();
        this.m_circle.m_radius = 0.5f;
        this.m_bodyIndex = 0;
        this.m_angle = 0.0f;
        this.m_mode = Mode.e_closest;
    }

    public void step(TestbedSettings testbedSettings) {
        boolean bl = !testbedSettings.pause || testbedSettings.singleStep;
        super.step(testbedSettings);
        this.addTextLine("Press 1-5 to drop stuff, m to change the mode");
        this.addTextLine("Polygon 1 is filtered");
        this.addTextLine("Mode = " + (Object)((Object)this.m_mode));
        float f = 11.0f;
        this.point1.set(0.0f, 10.0f);
        this.d.set(f * MathUtils.cos(this.m_angle), f * MathUtils.sin(this.m_angle));
        this.point2.set(this.point1);
        this.point2.addLocal(this.d);
        if (this.m_mode == Mode.e_closest) {
            this.ccallback.init();
            this.m_world.raycast(this.ccallback, this.point1, this.point2);
            if (this.ccallback.m_hit) {
                this.m_debugDraw.drawPoint(this.ccallback.m_point, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.m_debugDraw.drawSegment(this.point1, this.ccallback.m_point, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(this.ccallback.m_normal);
                this.pooledHead.mulLocal(0.5f).addLocal(this.ccallback.m_point);
                this.m_debugDraw.drawSegment(this.ccallback.m_point, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            } else {
                this.m_debugDraw.drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            }
        } else if (this.m_mode == Mode.e_any) {
            this.acallback.init();
            this.m_world.raycast(this.acallback, this.point1, this.point2);
            if (this.acallback.m_hit) {
                this.m_debugDraw.drawPoint(this.acallback.m_point, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.m_debugDraw.drawSegment(this.point1, this.acallback.m_point, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(this.acallback.m_normal);
                this.pooledHead.mulLocal(0.5f).addLocal(this.acallback.m_point);
                this.m_debugDraw.drawSegment(this.acallback.m_point, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            } else {
                this.m_debugDraw.drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            }
        } else if (this.m_mode == Mode.e_multiple) {
            this.mcallback.init();
            this.m_world.raycast(this.mcallback, this.point1, this.point2);
            this.m_debugDraw.drawSegment(this.point1, this.point2, new Color3f(0.8f, 0.8f, 0.8f));
            for (int i = 0; i < this.mcallback.m_count; ++i) {
                Vec2 vec2 = this.mcallback.m_points[i];
                Vec2 vec22 = this.mcallback.m_normals[i];
                this.m_debugDraw.drawPoint(vec2, 5.0f, new Color3f(0.4f, 0.9f, 0.4f));
                this.m_debugDraw.drawSegment(this.point1, vec2, new Color3f(0.8f, 0.8f, 0.8f));
                this.pooledHead.set(vec22);
                this.pooledHead.mulLocal(0.5f).addLocal(vec2);
                this.m_debugDraw.drawSegment(vec2, this.pooledHead, new Color3f(0.9f, 0.9f, 0.4f));
            }
        }
        if (bl) {
            this.m_angle += 0.004363323f;
        }
    }

    void Create(int n) {
        if (this.m_bodies[this.m_bodyIndex] != null) {
            this.m_world.destroyBody(this.m_bodies[this.m_bodyIndex]);
            this.m_bodies[this.m_bodyIndex] = null;
        }
        BodyDef bodyDef = new BodyDef();
        float f = (float)Math.random() * 20.0f - 10.0f;
        float f2 = (float)Math.random() * 20.0f;
        bodyDef.position.set(f, f2);
        bodyDef.angle = (float)Math.random() * ((float)Math.PI * 2) - (float)Math.PI;
        this.m_userData[this.m_bodyIndex] = n;
        bodyDef.userData = this.m_userData[this.m_bodyIndex];
        if (n == 4) {
            bodyDef.angularDamping = 0.02f;
        }
        this.m_bodies[this.m_bodyIndex] = this.m_world.createBody(bodyDef);
        if (n < 4) {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_polygons[n];
            fixtureDef.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        } else {
            FixtureDef fixtureDef = new FixtureDef();
            fixtureDef.shape = this.m_circle;
            fixtureDef.friction = 0.3f;
            this.m_bodies[this.m_bodyIndex].createFixture(fixtureDef);
        }
        this.m_bodyIndex = (this.m_bodyIndex + 1) % 256;
    }

    void DestroyBody() {
        for (int i = 0; i < 256; ++i) {
            if (this.m_bodies[i] == null) continue;
            this.m_world.destroyBody(this.m_bodies[i]);
            this.m_bodies[i] = null;
            return;
        }
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                this.Create(c - 49);
                break;
            }
            case 'd': {
                this.DestroyBody();
                break;
            }
            case 'm': {
                if (this.m_mode == Mode.e_closest) {
                    this.m_mode = Mode.e_any;
                    break;
                }
                if (this.m_mode == Mode.e_any) {
                    this.m_mode = Mode.e_multiple;
                    break;
                }
                if (this.m_mode != Mode.e_multiple) break;
                this.m_mode = Mode.e_closest;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode e_closest = new Mode();
        public static final /* enum */ Mode e_any = new Mode();
        public static final /* enum */ Mode e_multiple = new Mode();
        private static final /* synthetic */ Mode[] $VALUES;

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }

        static {
            $VALUES = new Mode[]{e_closest, e_any, e_multiple};
        }
    }
}

