/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import org.jbox2d.collision.shapes.CircleShape;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.collision.shapes.Shape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.Fixture;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class ShapeEditing
extends TestbedTest {
    Body m_body;
    Fixture m_fixture1;
    Fixture m_fixture2;

    public void initTest() {
        BodyDef bodyDef = new BodyDef();
        Object object = this.m_world.createBody(bodyDef);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        ((Body)object).createFixture(polygonShape, 0.0f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 10.0f);
        this.m_body = this.m_world.createBody(bodyDef);
        object = new PolygonShape();
        ((PolygonShape)object).setAsBox(4.0f, 4.0f, new Vec2(0.0f, 0.0f), 0.0f);
        this.m_fixture1 = this.m_body.createFixture((Shape)object, 10.0f);
        this.m_fixture2 = null;
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'c': {
                if (this.m_fixture2 != null) break;
                CircleShape circleShape = new CircleShape();
                circleShape.m_radius = 3.0f;
                circleShape.m_p.set(0.5f, -4.0f);
                this.m_fixture2 = this.m_body.createFixture(circleShape, 10.0f);
                this.m_body.setAwake(true);
                break;
            }
            case 'd': {
                if (this.m_fixture2 == null) break;
                this.m_body.destroyFixture(this.m_fixture2);
                this.m_fixture2 = null;
                this.m_body.setAwake(true);
            }
        }
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Press: (c) create a shape, (d) destroy a shape.");
    }

    public String getTestName() {
        return "Shape Editing";
    }
}

