/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.testbed.tests;

import java.util.Formatter;
import org.jbox2d.collision.shapes.PolygonShape;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.BodyDef;
import org.jbox2d.dynamics.BodyType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;
import org.jbox2d.testbed.framework.TestPanel;
import org.jbox2d.testbed.framework.TestbedSettings;
import org.jbox2d.testbed.framework.TestbedTest;

public class SliderCrankTest
extends TestbedTest {
    private RevoluteJoint m_joint1;
    private PrismaticJoint m_joint2;

    public void initTest() {
        Body body = null;
        Object object = new BodyDef();
        body = this.m_world.createBody((BodyDef)object);
        PolygonShape polygonShape = new PolygonShape();
        polygonShape.setAsEdge(new Vec2(-40.0f, 0.0f), new Vec2(40.0f, 0.0f));
        body.createFixture(polygonShape, 0.0f);
        object = body;
        polygonShape = new PolygonShape();
        polygonShape.setAsBox(0.5f, 2.0f);
        BodyDef bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 7.0f);
        Body body2 = this.m_world.createBody(bodyDef);
        body2.createFixture(polygonShape, 2.0f);
        RevoluteJointDef revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.initialize((Body)object, body2, new Vec2(0.0f, 5.0f));
        revoluteJointDef.motorSpeed = (float)Math.PI;
        revoluteJointDef.maxMotorTorque = 10000.0f;
        revoluteJointDef.enableMotor = true;
        this.m_joint1 = (RevoluteJoint)this.m_world.createJoint(revoluteJointDef);
        object = body2;
        polygonShape = new PolygonShape();
        polygonShape.setAsBox(0.5f, 4.0f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 13.0f);
        body2 = this.m_world.createBody(bodyDef);
        body2.createFixture(polygonShape, 2.0f);
        revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.initialize((Body)object, body2, new Vec2(0.0f, 9.0f));
        revoluteJointDef.enableMotor = false;
        this.m_world.createJoint(revoluteJointDef);
        object = body2;
        polygonShape = new PolygonShape();
        polygonShape.setAsBox(1.5f, 1.5f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 17.0f);
        body2 = this.m_world.createBody(bodyDef);
        body2.createFixture(polygonShape, 2.0f);
        revoluteJointDef = new RevoluteJointDef();
        revoluteJointDef.initialize((Body)object, body2, new Vec2(0.0f, 17.0f));
        this.m_world.createJoint(revoluteJointDef);
        PrismaticJointDef prismaticJointDef = new PrismaticJointDef();
        prismaticJointDef.initialize(body, body2, new Vec2(0.0f, 17.0f), new Vec2(0.0f, 1.0f));
        prismaticJointDef.maxMotorForce = 1000.0f;
        prismaticJointDef.enableMotor = true;
        this.m_joint2 = (PrismaticJoint)this.m_world.createJoint(prismaticJointDef);
        polygonShape = new PolygonShape();
        polygonShape.setAsBox(1.5f, 1.5f);
        bodyDef = new BodyDef();
        bodyDef.type = BodyType.DYNAMIC;
        bodyDef.position.set(0.0f, 23.0f);
        body2 = this.m_world.createBody(bodyDef);
        body2.createFixture(polygonShape, 2.0f);
    }

    public void step(TestbedSettings testbedSettings) {
        super.step(testbedSettings);
        this.addTextLine("Keys: (f) toggle friction, (m) toggle motor");
        float f = this.m_joint1.getMotorTorque();
        Formatter formatter = new Formatter();
        this.addTextLine(formatter.format("Friction: %b, Motor Force = %5.0f, ", this.m_joint2.isMotorEnabled(), Float.valueOf(f)).toString());
    }

    public void keyPressed(char c, int n) {
        switch (c) {
            case 'f': {
                this.m_joint2.enableMotor(!this.m_joint2.isMotorEnabled());
                TestPanel.keys[102] = false;
                break;
            }
            case 'm': {
                this.m_joint1.enableMotor(!this.m_joint1.isMotorEnabled());
                TestPanel.keys[109] = false;
            }
        }
    }

    public String getTestName() {
        return "Slider Crank";
    }
}

