/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.tests.math;

import org.jbox2d.common.MathUtils;

public class SinCosTable {
    public static final float TWOPI = (float)Math.PI * 2;
    public static boolean LERP_LOOKUP = true;
    public final float precision;
    public final int tableLength;
    public final float[] sinLUT;

    public SinCosTable(float f) {
        this.precision = f;
        this.tableLength = (int)Math.ceil((float)Math.PI * 2 / this.precision);
        this.sinLUT = new float[this.tableLength];
        for (int i = 0; i < this.tableLength; ++i) {
            this.sinLUT[i] = (float)Math.sin((float)i * this.precision);
        }
    }

    public final float sin(float f) {
        f %= (float)Math.PI * 2;
        if (LERP_LOOKUP) {
            int n = (int)(f /= this.precision);
            if (n != 0) {
                f %= (float)n;
            }
            if (n == this.tableLength - 1) {
                return (1.0f - f) * this.sinLUT[n] + f * this.sinLUT[0];
            }
            return (1.0f - f) * this.sinLUT[n] + f * this.sinLUT[n + 1];
        }
        return this.sinLUT[MathUtils.round(f / this.precision) % this.tableLength];
    }
}

