/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.tests.math;

import org.jbox2d.common.MathUtils;
import org.jbox2d.tests.math.SinCosTable;

public class SinCosTest {
    public static final int COLUMN_PADDING = 3;
    public static final int NUM_DECIMALS = 8;
    public static int numTables = 50;
    public static float mostPreciseTable = 1.0E-5f;
    public static float leastPreciseTable = 0.01f;
    public static int accuracyIterations = 100000;
    public static int speedTrials = 20;
    public static int speedIterations = 5000;
    private static SinCosTable[] tables;

    public static void main(String[] stringArray) {
        int n = 5;
        try {
            numTables = Integer.parseInt(stringArray[0]);
            mostPreciseTable = Float.parseFloat(stringArray[1]);
            leastPreciseTable = Float.parseFloat(stringArray[2]);
            accuracyIterations = Integer.parseInt(stringArray[3]);
            speedTrials = Integer.parseInt(stringArray[4]);
            speedIterations = Integer.parseInt(stringArray[5]);
            n = Integer.parseInt(stringArray[6]);
        }
        catch (Exception exception) {
            System.out.println("Parameters: <number of tables to use> <most precise table value (smallest)> <least precise table value> <number of accuracy test iterations> <number of speed test trials><number of speed test iterations> <number of overall speed test sets>");
            System.out.println("Sample parameters: 200 .00001 .01 100000 20 5000 2");
        }
        System.out.println("Tables: " + numTables);
        System.out.println("Most Precise Table: " + mostPreciseTable);
        System.out.println("Least Precise Table: " + leastPreciseTable);
        System.out.println("Accuracy Iterations: " + accuracyIterations);
        System.out.println("Speed Trials: " + speedTrials);
        System.out.println("Speed Iterations: " + speedIterations);
        SinCosTest.constructTables();
        SinCosTest.doAccuracyTest(true);
        for (int i = 0; i < n; ++i) {
            SinCosTest.doSpeedTest(true);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static final void constructTables() {
        tables = new SinCosTable[numTables];
        System.out.println("constructing tables");
        for (int i = 0; i < numTables; ++i) {
            float f = (float)i * 1.0f / (float)numTables * (leastPreciseTable - mostPreciseTable) + mostPreciseTable;
            SinCosTest.tables[i] = new SinCosTable(f);
        }
    }

    public static final double[][] doAccuracyTest(boolean bl) {
        int n;
        System.out.println("doing accuracy tests");
        double[][] dArray = new double[numTables][3];
        SinCosTable.LERP_LOOKUP = false;
        for (n = 0; n < numTables; ++n) {
            dArray[n][0] = SinCosTest.accuracyTest(tables[n], accuracyIterations);
        }
        SinCosTable.LERP_LOOKUP = true;
        for (n = 0; n < numTables; ++n) {
            dArray[n][1] = SinCosTest.accuracyTest(tables[n], accuracyIterations);
        }
        for (n = 0; n < numTables; ++n) {
            dArray[n][2] = dArray[n][0] - dArray[n][1];
        }
        if (bl) {
            System.out.println("Accuracy results, average displacement");
            String[] stringArray = new String[]{"Not lerped", "Lerped", "Difference"};
            String[] stringArray2 = new String[numTables + 1];
            stringArray2[0] = "Table precision";
            for (int i = 0; i < tables.length; ++i) {
                stringArray2[i + 1] = SinCosTest.formatDecimal(SinCosTest.tables[i].precision, 8);
            }
            SinCosTest.printTable(stringArray, stringArray2, dArray);
        }
        return dArray;
    }

    public static final double[][] doSpeedTest(boolean bl) {
        int n;
        System.out.println("\nDoing speed tests");
        double[][] dArray = new double[numTables][4];
        SinCosTable.LERP_LOOKUP = false;
        for (n = 0; n < numTables; ++n) {
            dArray[n][0] = SinCosTest.speedTest(tables[n], speedIterations, speedTrials);
        }
        SinCosTable.LERP_LOOKUP = true;
        for (n = 0; n < numTables; ++n) {
            dArray[n][1] = SinCosTest.speedTest(tables[n], speedIterations, speedTrials);
        }
        for (n = 0; n < numTables; ++n) {
            dArray[n][3] = SinCosTest.speedTestMath(speedIterations, speedTrials);
        }
        for (n = 0; n < numTables; ++n) {
            dArray[n][2] = dArray[n][0] - dArray[n][1];
        }
        if (bl) {
            System.out.println("Speed results, in iterations per second (higher number means faster)");
            String[] stringArray = new String[]{"Not lerped", "Lerped", "Difference", "Java Math"};
            String[] stringArray2 = new String[numTables + 1];
            stringArray2[0] = "Table precision";
            for (int i = 0; i < tables.length; ++i) {
                stringArray2[i + 1] = SinCosTest.formatDecimal(SinCosTest.tables[i].precision, 8);
            }
            SinCosTest.printTable(stringArray, stringArray2, dArray);
        }
        return dArray;
    }

    private static double accuracyTest(SinCosTable sinCosTable, int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            float f = (float)Math.random() * ((float)Math.PI * 2);
            d2 = MathUtils.abs((float)Math.sin(f) - sinCosTable.sin(f));
            d += d2;
        }
        return d /= (double)n;
    }

    private static void printTable(String[] stringArray, String[] stringArray2, double[][] dArray) {
        int n;
        int n2;
        int[] nArray = new int[dArray[0].length + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = 0;
        }
        for (n2 = -1; n2 < dArray[0].length; ++n2) {
            if (n2 == -1) {
                n = stringArray2[n2 + 1].length() + 3;
                if (n <= nArray[n2 + 1]) continue;
                nArray[n2 + 1] = n;
                continue;
            }
            n = stringArray[n2].length() + 3;
            if (n > nArray[n2 + 1]) {
                nArray[n2 + 1] = n;
            }
            for (int i = 0; i < dArray.length; ++i) {
                n = SinCosTest.formatDecimal(dArray[i][n2], 8).length() + 3;
                if (n <= nArray[n2 + 1]) continue;
                nArray[n2 + 1] = n;
            }
        }
        System.out.print(SinCosTest.spaceString(stringArray2[0], nArray[0]));
        for (n2 = 1; n2 < nArray.length; ++n2) {
            System.out.print(SinCosTest.spaceString(stringArray[n2 - 1], nArray[n2]));
        }
        System.out.println();
        for (n2 = 0; n2 < dArray.length; ++n2) {
            for (n = -1; n < dArray[n2].length; ++n) {
                if (n == -1) {
                    System.out.print(SinCosTest.spaceString(stringArray2[n2 + 1], nArray[n + 1]));
                    continue;
                }
                String string = SinCosTest.formatDecimal(dArray[n2][n], 8);
                System.out.print(SinCosTest.spaceString(string, nArray[n + 1]));
            }
            System.out.println();
        }
    }

    private static long speedTest(SinCosTable sinCosTable, int n, int n2) {
        long l = 0L;
        float f = 0.0f;
        float f2 = (float)Math.PI * 2 / (float)n;
        for (float f3 = 0.0f; f3 < (float)n2; f3 += 1.0f) {
            long l2 = System.nanoTime();
            for (float f4 = 0.0f; f4 < (float)Math.PI * 2; f4 += f2) {
                f += sinCosTable.sin(f4);
            }
            long l3 = System.nanoTime();
            l += l3 - l2;
        }
        return (long)(n * n2) * 1000000000L / l;
    }

    private static long speedTestMath(int n, int n2) {
        long l = 0L;
        float f = 0.0f;
        float f2 = (float)Math.PI * 2 / (float)n;
        for (float f3 = 0.0f; f3 < (float)n2; f3 += 1.0f) {
            long l2 = System.nanoTime();
            for (float f4 = 0.0f; f4 < (float)Math.PI * 2; f4 += f2) {
                f += (float)StrictMath.sin(f4);
            }
            long l3 = System.nanoTime();
            l += l3 - l2;
        }
        return (long)(n * n2) * 1000000000L / l;
    }

    private static String spaceString(String string, int n) {
        if (string.length() == n) {
            return string;
        }
        if (string.length() >= n) {
            return string.substring(0, n);
        }
        String string2 = new String(string);
        for (int i = string2.length(); i < n; ++i) {
            string2 = " " + string2;
        }
        return string2;
    }

    private static String formatDecimal(double d, int n) {
        String string = d + "";
        if (string.indexOf(".") == -1) {
            return string;
        }
        boolean bl = false;
        String string2 = null;
        if (string.indexOf("E") != -1) {
            string2 = string.substring(string.indexOf("E"));
            n -= string2.length();
            string = string.substring(0, string.indexOf("E"));
            bl = true;
        }
        int n2 = string.substring(string.indexOf(".") + 1).length();
        int n3 = string.substring(0, string.indexOf(".")).length();
        if (n2 < n) {
            for (int i = 0; i < n - n2; ++i) {
                string = string + " ";
            }
        } else if (n2 > n) {
            string = string.substring(0, n3 + n + 1);
        }
        if (bl) {
            string = string + string2;
        }
        return string;
    }
}

